package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetResourcesetListRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("hasResourceList")
    private Boolean hasResourceList = null;

    @JsonProperty("page")
    private Integer page = null;

    @JsonProperty("resourcesetIds")
    @Valid
    private List<Long> resourcesetIds = null;

    @JsonProperty("resourcesetName")
    private String resourcesetName = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private Integer row = null;

    @JsonProperty("status")
    private Integer status = null;

    public MsGetResourcesetListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetResourcesetListRequest withHasResourceList(Boolean hasResourceList) {
        this.hasResourceList = hasResourceList;
        return this;
    }

    /**
    * 是否包含资源码列表
    * @return hasResourceList
    **/
    @ApiModelProperty(example = "false", value = "是否包含资源码列表")


    public Boolean isgetHasResourceList() {
        return hasResourceList;
    }

    public void setHasResourceList(Boolean hasResourceList) {
        this.hasResourceList = hasResourceList;
    }

    public MsGetResourcesetListRequest withPage(Integer page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public MsGetResourcesetListRequest withResourcesetIds(List<Long> resourcesetIds) {
        this.resourcesetIds = resourcesetIds;
        return this;
    }

    public MsGetResourcesetListRequest withResourcesetIdsAdd(Long resourcesetIds) {
        if (this.resourcesetIds == null) {
            this.resourcesetIds = new ArrayList<Long>();
        }
        this.resourcesetIds.add(resourcesetIds);
        return this;
    }

    /**
    * 功能集id集合
    * @return resourcesetIds
    **/
    @ApiModelProperty(value = "功能集id集合")


    public List<Long> getResourcesetIds() {
        return resourcesetIds;
    }

    public void setResourcesetIds(List<Long> resourcesetIds) {
        this.resourcesetIds = resourcesetIds;
    }

    public MsGetResourcesetListRequest withResourcesetName(String resourcesetName) {
        this.resourcesetName = resourcesetName;
        return this;
    }

    /**
    * 功能集名称
    * @return resourcesetName
    **/
    @ApiModelProperty(value = "功能集名称")


    public String getResourcesetName() {
        return resourcesetName;
    }

    public void setResourcesetName(String resourcesetName) {
        this.resourcesetName = resourcesetName;
    }

    public MsGetResourcesetListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetResourcesetListRequest withRow(Integer row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public Integer getRow() {
        return row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    public MsGetResourcesetListRequest withStatus(Integer status) {
        this.status = status;
        return this;
    }

    /**
    * 功能集状态
    * @return status
    **/
    @ApiModelProperty(value = "功能集状态")


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetResourcesetListRequest msGetResourcesetListRequest = (MsGetResourcesetListRequest) o;
        return Objects.equals(this.appid, msGetResourcesetListRequest.appid) &&
            Objects.equals(this.hasResourceList, msGetResourcesetListRequest.hasResourceList) &&
            Objects.equals(this.page, msGetResourcesetListRequest.page) &&
            Objects.equals(this.resourcesetIds, msGetResourcesetListRequest.resourcesetIds) &&
            Objects.equals(this.resourcesetName, msGetResourcesetListRequest.resourcesetName) &&
            Objects.equals(this.rid, msGetResourcesetListRequest.rid) &&
            Objects.equals(this.row, msGetResourcesetListRequest.row) &&
            Objects.equals(this.status, msGetResourcesetListRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, hasResourceList, page, resourcesetIds, resourcesetName, rid, row, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetResourcesetListRequest }.
     */
    public static MsGetResourcesetListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetResourcesetListRequest.class);
    }
}

