package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetRoleDetailRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("roleId")
    private Long roleId = null;

    public MsGetRoleDetailRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetRoleDetailRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetRoleDetailRequest withRoleId(Long roleId) {
        this.roleId = roleId;
        return this;
    }

    /**
    * ID
    * @return roleId
    **/
    @ApiModelProperty(value = "ID")


    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetRoleDetailRequest msGetRoleDetailRequest = (MsGetRoleDetailRequest) o;
        return Objects.equals(this.appid, msGetRoleDetailRequest.appid) &&
            Objects.equals(this.rid, msGetRoleDetailRequest.rid) &&
            Objects.equals(this.roleId, msGetRoleDetailRequest.roleId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, rid, roleId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetRoleDetailRequest }.
     */
    public static MsGetRoleDetailRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetRoleDetailRequest.class);
    }
}

