package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetRoleListRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("groupId")
    private String groupId = null;

    @JsonProperty("isFilterId")
    private Boolean isFilterId = null;

    @JsonProperty("page")
    private Integer page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("roleCode")
    private String roleCode = null;

    @JsonProperty("roleId")
    private String roleId = null;

    @JsonProperty("roleName")
    private String roleName = null;

    @JsonProperty("row")
    private Integer row = null;

    @JsonProperty("status")
    private String status = null;

    public MsGetRoleListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetRoleListRequest withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团Id
    * @return groupId
    **/
    @ApiModelProperty(value = "集团Id")


    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public MsGetRoleListRequest withIsFilterId(Boolean isFilterId) {
        this.isFilterId = isFilterId;
        return this;
    }

    /**
    * 是否过滤主键
    * @return isFilterId
    **/
    @ApiModelProperty(example = "false", value = "是否过滤主键")


    public Boolean isgetIsFilterId() {
        return isFilterId;
    }

    public void setIsFilterId(Boolean isFilterId) {
        this.isFilterId = isFilterId;
    }

    public MsGetRoleListRequest withPage(Integer page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public MsGetRoleListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetRoleListRequest withRoleCode(String roleCode) {
        this.roleCode = roleCode;
        return this;
    }

    /**
    * 角色代码
    * @return roleCode
    **/
    @ApiModelProperty(value = "角色代码")


    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public MsGetRoleListRequest withRoleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    /**
    * 角色Id
    * @return roleId
    **/
    @ApiModelProperty(value = "角色Id")


    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public MsGetRoleListRequest withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    /**
    * 角色名称
    * @return roleName
    **/
    @ApiModelProperty(value = "角色名称")


    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public MsGetRoleListRequest withRow(Integer row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public Integer getRow() {
        return row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    public MsGetRoleListRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 角色状态
    * @return status
    **/
    @ApiModelProperty(value = "角色状态")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetRoleListRequest msGetRoleListRequest = (MsGetRoleListRequest) o;
        return Objects.equals(this.appid, msGetRoleListRequest.appid) &&
            Objects.equals(this.groupId, msGetRoleListRequest.groupId) &&
            Objects.equals(this.isFilterId, msGetRoleListRequest.isFilterId) &&
            Objects.equals(this.page, msGetRoleListRequest.page) &&
            Objects.equals(this.rid, msGetRoleListRequest.rid) &&
            Objects.equals(this.roleCode, msGetRoleListRequest.roleCode) &&
            Objects.equals(this.roleId, msGetRoleListRequest.roleId) &&
            Objects.equals(this.roleName, msGetRoleListRequest.roleName) &&
            Objects.equals(this.row, msGetRoleListRequest.row) &&
            Objects.equals(this.status, msGetRoleListRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, groupId, isFilterId, page, rid, roleCode, roleId, roleName, row, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetRoleListRequest }.
     */
    public static MsGetRoleListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetRoleListRequest.class);
    }
}

