package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetRoleResourcesetRelListRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("groupId")
    private Long groupId = null;

    @JsonProperty("page")
    private Integer page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("roleId")
    private Long roleId = null;

    @JsonProperty("row")
    private Integer row = null;

    public MsGetRoleResourcesetRelListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetRoleResourcesetRelListRequest withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团Id
    * @return groupId
    **/
    @ApiModelProperty(value = "集团Id")


    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public MsGetRoleResourcesetRelListRequest withPage(Integer page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public MsGetRoleResourcesetRelListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetRoleResourcesetRelListRequest withRoleId(Long roleId) {
        this.roleId = roleId;
        return this;
    }

    /**
    * 角色id
    * @return roleId
    **/
    @ApiModelProperty(value = "角色id")


    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public MsGetRoleResourcesetRelListRequest withRow(Integer row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public Integer getRow() {
        return row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetRoleResourcesetRelListRequest msGetRoleResourcesetRelListRequest = (MsGetRoleResourcesetRelListRequest) o;
        return Objects.equals(this.appid, msGetRoleResourcesetRelListRequest.appid) &&
            Objects.equals(this.groupId, msGetRoleResourcesetRelListRequest.groupId) &&
            Objects.equals(this.page, msGetRoleResourcesetRelListRequest.page) &&
            Objects.equals(this.rid, msGetRoleResourcesetRelListRequest.rid) &&
            Objects.equals(this.roleId, msGetRoleResourcesetRelListRequest.roleId) &&
            Objects.equals(this.row, msGetRoleResourcesetRelListRequest.row);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, groupId, page, rid, roleId, row);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetRoleResourcesetRelListRequest }.
     */
    public static MsGetRoleResourcesetRelListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetRoleResourcesetRelListRequest.class);
    }
}

