package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetServiceApiDetailRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("checkParamFlag")
    private Boolean checkParamFlag = null;

    @JsonProperty("resourceId")
    private Long resourceId = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("serviceApiId")
    private Long serviceApiId = null;

    @JsonProperty("serviceApiName")
    private String serviceApiName = null;

    @JsonProperty("serviceApiUrl")
    private String serviceApiUrl = null;

    public MsGetServiceApiDetailRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetServiceApiDetailRequest withCheckParamFlag(Boolean checkParamFlag) {
        this.checkParamFlag = checkParamFlag;
        return this;
    }

    /**
    * 是否是名称/其他 参数验证
    * @return checkParamFlag
    **/
    @ApiModelProperty(example = "false", value = "是否是名称/其他 参数验证")


    public Boolean isgetCheckParamFlag() {
        return checkParamFlag;
    }

    public void setCheckParamFlag(Boolean checkParamFlag) {
        this.checkParamFlag = checkParamFlag;
    }

    public MsGetServiceApiDetailRequest withResourceId(Long resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
    * 资源码id
    * @return resourceId
    **/
    @ApiModelProperty(value = "资源码id")


    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public MsGetServiceApiDetailRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetServiceApiDetailRequest withServiceApiId(Long serviceApiId) {
        this.serviceApiId = serviceApiId;
        return this;
    }

    /**
    * ID
    * @return serviceApiId
    **/
    @ApiModelProperty(value = "ID")


    public Long getServiceApiId() {
        return serviceApiId;
    }

    public void setServiceApiId(Long serviceApiId) {
        this.serviceApiId = serviceApiId;
    }

    public MsGetServiceApiDetailRequest withServiceApiName(String serviceApiName) {
        this.serviceApiName = serviceApiName;
        return this;
    }

    /**
    * Api名称
    * @return serviceApiName
    **/
    @ApiModelProperty(value = "Api名称")


    public String getServiceApiName() {
        return serviceApiName;
    }

    public void setServiceApiName(String serviceApiName) {
        this.serviceApiName = serviceApiName;
    }

    public MsGetServiceApiDetailRequest withServiceApiUrl(String serviceApiUrl) {
        this.serviceApiUrl = serviceApiUrl;
        return this;
    }

    /**
    * Api Url
    * @return serviceApiUrl
    **/
    @ApiModelProperty(value = "Api Url")


    public String getServiceApiUrl() {
        return serviceApiUrl;
    }

    public void setServiceApiUrl(String serviceApiUrl) {
        this.serviceApiUrl = serviceApiUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetServiceApiDetailRequest msGetServiceApiDetailRequest = (MsGetServiceApiDetailRequest) o;
        return Objects.equals(this.appid, msGetServiceApiDetailRequest.appid) &&
            Objects.equals(this.checkParamFlag, msGetServiceApiDetailRequest.checkParamFlag) &&
            Objects.equals(this.resourceId, msGetServiceApiDetailRequest.resourceId) &&
            Objects.equals(this.rid, msGetServiceApiDetailRequest.rid) &&
            Objects.equals(this.serviceApiId, msGetServiceApiDetailRequest.serviceApiId) &&
            Objects.equals(this.serviceApiName, msGetServiceApiDetailRequest.serviceApiName) &&
            Objects.equals(this.serviceApiUrl, msGetServiceApiDetailRequest.serviceApiUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, checkParamFlag, resourceId, rid, serviceApiId, serviceApiName, serviceApiUrl);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetServiceApiDetailRequest }.
     */
    public static MsGetServiceApiDetailRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetServiceApiDetailRequest.class);
    }
}

