package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetServiceApiListRequest   {
    @JsonProperty("ServiceApiName")
    private String serviceApiName = null;

    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("page")
    private Integer page = null;

    @JsonProperty("resourceId")
    private Long resourceId = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private Integer row = null;

    @JsonProperty("status")
    private Integer status = null;

    public MsGetServiceApiListRequest withServiceApiName(String serviceApiName) {
        this.serviceApiName = serviceApiName;
        return this;
    }

    /**
    * 服务Api名称
    * @return serviceApiName
    **/
    @ApiModelProperty(value = "服务Api名称")


    public String getServiceApiName() {
        return serviceApiName;
    }

    public void setServiceApiName(String serviceApiName) {
        this.serviceApiName = serviceApiName;
    }

    public MsGetServiceApiListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetServiceApiListRequest withPage(Integer page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public MsGetServiceApiListRequest withResourceId(Long resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
    * 资源码id
    * @return resourceId
    **/
    @ApiModelProperty(value = "资源码id")


    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public MsGetServiceApiListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetServiceApiListRequest withRow(Integer row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public Integer getRow() {
        return row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    public MsGetServiceApiListRequest withStatus(Integer status) {
        this.status = status;
        return this;
    }

    /**
    * 服务Api状态
    * @return status
    **/
    @ApiModelProperty(value = "服务Api状态")


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetServiceApiListRequest msGetServiceApiListRequest = (MsGetServiceApiListRequest) o;
        return Objects.equals(this.serviceApiName, msGetServiceApiListRequest.serviceApiName) &&
            Objects.equals(this.appid, msGetServiceApiListRequest.appid) &&
            Objects.equals(this.page, msGetServiceApiListRequest.page) &&
            Objects.equals(this.resourceId, msGetServiceApiListRequest.resourceId) &&
            Objects.equals(this.rid, msGetServiceApiListRequest.rid) &&
            Objects.equals(this.row, msGetServiceApiListRequest.row) &&
            Objects.equals(this.status, msGetServiceApiListRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(serviceApiName, appid, page, resourceId, rid, row, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetServiceApiListRequest }.
     */
    public static MsGetServiceApiListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetServiceApiListRequest.class);
    }
}

