package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetSmsValidCodeDetailRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("loginType")
    private Integer loginType = null;

    @JsonProperty("phone")
    private String phone = null;

    @JsonProperty("rid")
    private String rid = null;

    public MsGetSmsValidCodeDetailRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetSmsValidCodeDetailRequest withLoginType(Integer loginType) {
        this.loginType = loginType;
        return this;
    }

    /**
    * 登录类型 1登录错误类型 2发送验证码错误类型（记录同一账号发送次数）
    * @return loginType
    **/
    @ApiModelProperty(value = "登录类型 1登录错误类型 2发送验证码错误类型（记录同一账号发送次数）")


    public Integer getLoginType() {
        return loginType;
    }

    public void setLoginType(Integer loginType) {
        this.loginType = loginType;
    }

    public MsGetSmsValidCodeDetailRequest withPhone(String phone) {
        this.phone = phone;
        return this;
    }

    /**
    * 手机号码
    * @return phone
    **/
    @ApiModelProperty(value = "手机号码")


    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public MsGetSmsValidCodeDetailRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetSmsValidCodeDetailRequest msGetSmsValidCodeDetailRequest = (MsGetSmsValidCodeDetailRequest) o;
        return Objects.equals(this.appid, msGetSmsValidCodeDetailRequest.appid) &&
            Objects.equals(this.loginType, msGetSmsValidCodeDetailRequest.loginType) &&
            Objects.equals(this.phone, msGetSmsValidCodeDetailRequest.phone) &&
            Objects.equals(this.rid, msGetSmsValidCodeDetailRequest.rid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, loginType, phone, rid);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetSmsValidCodeDetailRequest }.
     */
    public static MsGetSmsValidCodeDetailRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetSmsValidCodeDetailRequest.class);
    }
}

