package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetUserListRequest   {
    @JsonProperty("accountId")
    private Long accountId = null;

    @JsonProperty("activeStatus")
    private String activeStatus = null;

    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("groupId")
    private Long groupId = null;

    @JsonProperty("page")
    private Integer page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private Integer row = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("user")
    private String user = null;

    @JsonProperty("userEmailAddr")
    private String userEmailAddr = null;

    @JsonProperty("userPhone")
    private String userPhone = null;

    public MsGetUserListRequest withAccountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    /**
    * 账号id
    * @return accountId
    **/
    @ApiModelProperty(value = "账号id")


    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public MsGetUserListRequest withActiveStatus(String activeStatus) {
        this.activeStatus = activeStatus;
        return this;
    }

    /**
    * 账户状态 1:已激活 0：未激活
    * @return activeStatus
    **/
    @ApiModelProperty(value = "账户状态 1:已激活 0：未激活")


    public String getActiveStatus() {
        return activeStatus;
    }

    public void setActiveStatus(String activeStatus) {
        this.activeStatus = activeStatus;
    }

    public MsGetUserListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetUserListRequest withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团id
    * @return groupId
    **/
    @ApiModelProperty(value = "集团id")


    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public MsGetUserListRequest withPage(Integer page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public MsGetUserListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetUserListRequest withRow(Integer row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public Integer getRow() {
        return row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    public MsGetUserListRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态 1:启用  0：停用
    * @return status
    **/
    @ApiModelProperty(value = "状态 1:启用  0：停用")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public MsGetUserListRequest withUser(String user) {
        this.user = user;
        return this;
    }

    /**
    * 人员代码/人员工号/人员名称
    * @return user
    **/
    @ApiModelProperty(value = "人员代码/人员工号/人员名称")


    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public MsGetUserListRequest withUserEmailAddr(String userEmailAddr) {
        this.userEmailAddr = userEmailAddr;
        return this;
    }

    /**
    * 邮箱地址
    * @return userEmailAddr
    **/
    @ApiModelProperty(value = "邮箱地址")


    public String getUserEmailAddr() {
        return userEmailAddr;
    }

    public void setUserEmailAddr(String userEmailAddr) {
        this.userEmailAddr = userEmailAddr;
    }

    public MsGetUserListRequest withUserPhone(String userPhone) {
        this.userPhone = userPhone;
        return this;
    }

    /**
    * 手机号码
    * @return userPhone
    **/
    @ApiModelProperty(value = "手机号码")


    public String getUserPhone() {
        return userPhone;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetUserListRequest msGetUserListRequest = (MsGetUserListRequest) o;
        return Objects.equals(this.accountId, msGetUserListRequest.accountId) &&
            Objects.equals(this.activeStatus, msGetUserListRequest.activeStatus) &&
            Objects.equals(this.appid, msGetUserListRequest.appid) &&
            Objects.equals(this.groupId, msGetUserListRequest.groupId) &&
            Objects.equals(this.page, msGetUserListRequest.page) &&
            Objects.equals(this.rid, msGetUserListRequest.rid) &&
            Objects.equals(this.row, msGetUserListRequest.row) &&
            Objects.equals(this.status, msGetUserListRequest.status) &&
            Objects.equals(this.user, msGetUserListRequest.user) &&
            Objects.equals(this.userEmailAddr, msGetUserListRequest.userEmailAddr) &&
            Objects.equals(this.userPhone, msGetUserListRequest.userPhone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountId, activeStatus, appid, groupId, page, rid, row, status, user, userEmailAddr, userPhone);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetUserListRequest }.
     */
    public static MsGetUserListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetUserListRequest.class);
    }
}

