package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.yiwan.seiya.phoenix.ucenter.service.model.MsSysUserDTO;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsOperateOpenApiUserRequest   {
    @JsonProperty("OpenApiUserInfo")
    private MsSysUserDTO openApiUserInfo = null;

    @JsonProperty("appid")
    private String appid = null;

  /**
   * 操作类型
   */
  public enum DoTypeEnum {
    I("I"),
    
    U("U"),
    
    D("D");

    private String value;

    DoTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DoTypeEnum fromValue(String text) {
      for (DoTypeEnum b : DoTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("doType")
    private DoTypeEnum doType = null;

    @JsonProperty("operater")
    private String operater = null;

    @JsonProperty("operaterid")
    private String operaterid = null;

    @JsonProperty("rid")
    private String rid = null;

    public MsOperateOpenApiUserRequest withOpenApiUserInfo(MsSysUserDTO openApiUserInfo) {
        this.openApiUserInfo = openApiUserInfo;
        return this;
    }

    /**
    * Get openApiUserInfo
    * @return openApiUserInfo
    **/
    @ApiModelProperty(value = "")

  @Valid

    public MsSysUserDTO getOpenApiUserInfo() {
        return openApiUserInfo;
    }

    public void setOpenApiUserInfo(MsSysUserDTO openApiUserInfo) {
        this.openApiUserInfo = openApiUserInfo;
    }

    public MsOperateOpenApiUserRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(value = "请求应用ID")


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsOperateOpenApiUserRequest withDoType(DoTypeEnum doType) {
        this.doType = doType;
        return this;
    }

    /**
    * 操作类型
    * @return doType
    **/
    @ApiModelProperty(value = "操作类型")


    public DoTypeEnum getDoType() {
        return doType;
    }

    public void setDoType(DoTypeEnum doType) {
        this.doType = doType;
    }

    public MsOperateOpenApiUserRequest withOperater(String operater) {
        this.operater = operater;
        return this;
    }

    /**
    * 操作人
    * @return operater
    **/
    @ApiModelProperty(value = "操作人")


    public String getOperater() {
        return operater;
    }

    public void setOperater(String operater) {
        this.operater = operater;
    }

    public MsOperateOpenApiUserRequest withOperaterid(String operaterid) {
        this.operaterid = operaterid;
        return this;
    }

    /**
    * 操作人ID
    * @return operaterid
    **/
    @ApiModelProperty(value = "操作人ID")


    public String getOperaterid() {
        return operaterid;
    }

    public void setOperaterid(String operaterid) {
        this.operaterid = operaterid;
    }

    public MsOperateOpenApiUserRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsOperateOpenApiUserRequest msOperateOpenApiUserRequest = (MsOperateOpenApiUserRequest) o;
        return Objects.equals(this.openApiUserInfo, msOperateOpenApiUserRequest.openApiUserInfo) &&
            Objects.equals(this.appid, msOperateOpenApiUserRequest.appid) &&
            Objects.equals(this.doType, msOperateOpenApiUserRequest.doType) &&
            Objects.equals(this.operater, msOperateOpenApiUserRequest.operater) &&
            Objects.equals(this.operaterid, msOperateOpenApiUserRequest.operaterid) &&
            Objects.equals(this.rid, msOperateOpenApiUserRequest.rid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(openApiUserInfo, appid, doType, operater, operaterid, rid);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsOperateOpenApiUserRequest }.
     */
    public static MsOperateOpenApiUserRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsOperateOpenApiUserRequest.class);
    }
}

