package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.yiwan.seiya.phoenix.ucenter.service.model.MsSysOrgUserRelDTO;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 操作人员角色关联信息
 */
@ApiModel(description = "操作人员角色关联信息")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsOperateOrgUserRelRequest   {
    @JsonProperty("appid")
    private String appid = null;

  /**
   * 操作类型
   */
  public enum DeleteTypeEnum {
    RELID("RELID"),
    
    USERID("USERID"),
    
    ORGSTRUCTID("ORGSTRUCTID");

    private String value;

    DeleteTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DeleteTypeEnum fromValue(String text) {
      for (DeleteTypeEnum b : DeleteTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("deleteType")
    private DeleteTypeEnum deleteType = null;

  /**
   * 操作类型
   */
  public enum DoTypeEnum {
    I("I"),
    
    D("D");

    private String value;

    DoTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DoTypeEnum fromValue(String text) {
      for (DoTypeEnum b : DoTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("doType")
    private DoTypeEnum doType = null;

    @JsonProperty("operater")
    private String operater = null;

    @JsonProperty("operaterid")
    private String operaterid = null;

    @JsonProperty("orgUserRelInfo")
    private MsSysOrgUserRelDTO orgUserRelInfo = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("value")
    private Long value = null;

    public MsOperateOrgUserRelRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(value = "请求应用ID")


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsOperateOrgUserRelRequest withDeleteType(DeleteTypeEnum deleteType) {
        this.deleteType = deleteType;
        return this;
    }

    /**
    * 操作类型
    * @return deleteType
    **/
    @ApiModelProperty(value = "操作类型")


    public DeleteTypeEnum getDeleteType() {
        return deleteType;
    }

    public void setDeleteType(DeleteTypeEnum deleteType) {
        this.deleteType = deleteType;
    }

    public MsOperateOrgUserRelRequest withDoType(DoTypeEnum doType) {
        this.doType = doType;
        return this;
    }

    /**
    * 操作类型
    * @return doType
    **/
    @ApiModelProperty(value = "操作类型")


    public DoTypeEnum getDoType() {
        return doType;
    }

    public void setDoType(DoTypeEnum doType) {
        this.doType = doType;
    }

    public MsOperateOrgUserRelRequest withOperater(String operater) {
        this.operater = operater;
        return this;
    }

    /**
    * 操作人
    * @return operater
    **/
    @ApiModelProperty(value = "操作人")


    public String getOperater() {
        return operater;
    }

    public void setOperater(String operater) {
        this.operater = operater;
    }

    public MsOperateOrgUserRelRequest withOperaterid(String operaterid) {
        this.operaterid = operaterid;
        return this;
    }

    /**
    * 操作人ID
    * @return operaterid
    **/
    @ApiModelProperty(value = "操作人ID")


    public String getOperaterid() {
        return operaterid;
    }

    public void setOperaterid(String operaterid) {
        this.operaterid = operaterid;
    }

    public MsOperateOrgUserRelRequest withOrgUserRelInfo(MsSysOrgUserRelDTO orgUserRelInfo) {
        this.orgUserRelInfo = orgUserRelInfo;
        return this;
    }

    /**
    * Get orgUserRelInfo
    * @return orgUserRelInfo
    **/
    @ApiModelProperty(value = "")

  @Valid

    public MsSysOrgUserRelDTO getOrgUserRelInfo() {
        return orgUserRelInfo;
    }

    public void setOrgUserRelInfo(MsSysOrgUserRelDTO orgUserRelInfo) {
        this.orgUserRelInfo = orgUserRelInfo;
    }

    public MsOperateOrgUserRelRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsOperateOrgUserRelRequest withValue(Long value) {
        this.value = value;
        return this;
    }

    /**
    * 删除值
    * @return value
    **/
    @ApiModelProperty(value = "删除值")


    public Long getValue() {
        return value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsOperateOrgUserRelRequest msOperateOrgUserRelRequest = (MsOperateOrgUserRelRequest) o;
        return Objects.equals(this.appid, msOperateOrgUserRelRequest.appid) &&
            Objects.equals(this.deleteType, msOperateOrgUserRelRequest.deleteType) &&
            Objects.equals(this.doType, msOperateOrgUserRelRequest.doType) &&
            Objects.equals(this.operater, msOperateOrgUserRelRequest.operater) &&
            Objects.equals(this.operaterid, msOperateOrgUserRelRequest.operaterid) &&
            Objects.equals(this.orgUserRelInfo, msOperateOrgUserRelRequest.orgUserRelInfo) &&
            Objects.equals(this.rid, msOperateOrgUserRelRequest.rid) &&
            Objects.equals(this.value, msOperateOrgUserRelRequest.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, deleteType, doType, operater, operaterid, orgUserRelInfo, rid, value);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsOperateOrgUserRelRequest }.
     */
    public static MsOperateOrgUserRelRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsOperateOrgUserRelRequest.class);
    }
}

