package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 操作人员角色关联信息
 */
@ApiModel(description = "操作人员角色关联信息")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsOperateRoleUserRelExtRequest   {
    @JsonProperty("appid")
    private String appid = null;

  /**
   * 操作类型
   */
  public enum DoTypeEnum {
    I("I"),
    
    D("D");

    private String value;

    DoTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DoTypeEnum fromValue(String text) {
      for (DoTypeEnum b : DoTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("doType")
    private DoTypeEnum doType = null;

    @JsonProperty("groupId")
    private Long groupId = null;

    @JsonProperty("operater")
    private String operater = null;

    @JsonProperty("operaterid")
    private String operaterid = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("roleId")
    private Long roleId = null;

    @JsonProperty("userIds")
    @Valid
    private List<Integer> userIds = null;

    public MsOperateRoleUserRelExtRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(value = "请求应用ID")


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsOperateRoleUserRelExtRequest withDoType(DoTypeEnum doType) {
        this.doType = doType;
        return this;
    }

    /**
    * 操作类型
    * @return doType
    **/
    @ApiModelProperty(value = "操作类型")


    public DoTypeEnum getDoType() {
        return doType;
    }

    public void setDoType(DoTypeEnum doType) {
        this.doType = doType;
    }

    public MsOperateRoleUserRelExtRequest withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团id
    * @return groupId
    **/
    @ApiModelProperty(value = "集团id")


    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public MsOperateRoleUserRelExtRequest withOperater(String operater) {
        this.operater = operater;
        return this;
    }

    /**
    * 操作人
    * @return operater
    **/
    @ApiModelProperty(value = "操作人")


    public String getOperater() {
        return operater;
    }

    public void setOperater(String operater) {
        this.operater = operater;
    }

    public MsOperateRoleUserRelExtRequest withOperaterid(String operaterid) {
        this.operaterid = operaterid;
        return this;
    }

    /**
    * 操作人ID
    * @return operaterid
    **/
    @ApiModelProperty(value = "操作人ID")


    public String getOperaterid() {
        return operaterid;
    }

    public void setOperaterid(String operaterid) {
        this.operaterid = operaterid;
    }

    public MsOperateRoleUserRelExtRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsOperateRoleUserRelExtRequest withRoleId(Long roleId) {
        this.roleId = roleId;
        return this;
    }

    /**
    * 角色id
    * @return roleId
    **/
    @ApiModelProperty(value = "角色id")


    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public MsOperateRoleUserRelExtRequest withUserIds(List<Integer> userIds) {
        this.userIds = userIds;
        return this;
    }

    public MsOperateRoleUserRelExtRequest withUserIdsAdd(Integer userIds) {
        if (this.userIds == null) {
            this.userIds = new ArrayList<Integer>();
        }
        this.userIds.add(userIds);
        return this;
    }

    /**
    * 用户ids
    * @return userIds
    **/
    @ApiModelProperty(value = "用户ids")


    public List<Integer> getUserIds() {
        return userIds;
    }

    public void setUserIds(List<Integer> userIds) {
        this.userIds = userIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsOperateRoleUserRelExtRequest msOperateRoleUserRelExtRequest = (MsOperateRoleUserRelExtRequest) o;
        return Objects.equals(this.appid, msOperateRoleUserRelExtRequest.appid) &&
            Objects.equals(this.doType, msOperateRoleUserRelExtRequest.doType) &&
            Objects.equals(this.groupId, msOperateRoleUserRelExtRequest.groupId) &&
            Objects.equals(this.operater, msOperateRoleUserRelExtRequest.operater) &&
            Objects.equals(this.operaterid, msOperateRoleUserRelExtRequest.operaterid) &&
            Objects.equals(this.rid, msOperateRoleUserRelExtRequest.rid) &&
            Objects.equals(this.roleId, msOperateRoleUserRelExtRequest.roleId) &&
            Objects.equals(this.userIds, msOperateRoleUserRelExtRequest.userIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, doType, groupId, operater, operaterid, rid, roleId, userIds);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsOperateRoleUserRelExtRequest }.
     */
    public static MsOperateRoleUserRelExtRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsOperateRoleUserRelExtRequest.class);
    }
}

