package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 操作人员角色关联信息
 */
@ApiModel(description = "操作人员角色关联信息")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsOperateRoleUserRelRequest   {
    @JsonProperty("appid")
    private String appid = null;

  /**
   * 操作类型
   */
  public enum DoTypeEnum {
    I("I"),
    
    D("D");

    private String value;

    DoTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DoTypeEnum fromValue(String text) {
      for (DoTypeEnum b : DoTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("doType")
    private DoTypeEnum doType = null;

    @JsonProperty("groupId")
    private Long groupId = null;

    @JsonProperty("operater")
    private String operater = null;

    @JsonProperty("operaterid")
    private String operaterid = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("roleIds")
    @Valid
    private List<Long> roleIds = null;

    @JsonProperty("userId")
    private Long userId = null;

    public MsOperateRoleUserRelRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(value = "请求应用ID")


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsOperateRoleUserRelRequest withDoType(DoTypeEnum doType) {
        this.doType = doType;
        return this;
    }

    /**
    * 操作类型
    * @return doType
    **/
    @ApiModelProperty(value = "操作类型")


    public DoTypeEnum getDoType() {
        return doType;
    }

    public void setDoType(DoTypeEnum doType) {
        this.doType = doType;
    }

    public MsOperateRoleUserRelRequest withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团id
    * @return groupId
    **/
    @ApiModelProperty(value = "集团id")


    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public MsOperateRoleUserRelRequest withOperater(String operater) {
        this.operater = operater;
        return this;
    }

    /**
    * 操作人
    * @return operater
    **/
    @ApiModelProperty(value = "操作人")


    public String getOperater() {
        return operater;
    }

    public void setOperater(String operater) {
        this.operater = operater;
    }

    public MsOperateRoleUserRelRequest withOperaterid(String operaterid) {
        this.operaterid = operaterid;
        return this;
    }

    /**
    * 操作人ID
    * @return operaterid
    **/
    @ApiModelProperty(value = "操作人ID")


    public String getOperaterid() {
        return operaterid;
    }

    public void setOperaterid(String operaterid) {
        this.operaterid = operaterid;
    }

    public MsOperateRoleUserRelRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsOperateRoleUserRelRequest withRoleIds(List<Long> roleIds) {
        this.roleIds = roleIds;
        return this;
    }

    public MsOperateRoleUserRelRequest withRoleIdsAdd(Long roleIds) {
        if (this.roleIds == null) {
            this.roleIds = new ArrayList<Long>();
        }
        this.roleIds.add(roleIds);
        return this;
    }

    /**
    * 角色ids
    * @return roleIds
    **/
    @ApiModelProperty(value = "角色ids")


    public List<Long> getRoleIds() {
        return roleIds;
    }

    public void setRoleIds(List<Long> roleIds) {
        this.roleIds = roleIds;
    }

    public MsOperateRoleUserRelRequest withUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    /**
    * 用户id
    * @return userId
    **/
    @ApiModelProperty(value = "用户id")


    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsOperateRoleUserRelRequest msOperateRoleUserRelRequest = (MsOperateRoleUserRelRequest) o;
        return Objects.equals(this.appid, msOperateRoleUserRelRequest.appid) &&
            Objects.equals(this.doType, msOperateRoleUserRelRequest.doType) &&
            Objects.equals(this.groupId, msOperateRoleUserRelRequest.groupId) &&
            Objects.equals(this.operater, msOperateRoleUserRelRequest.operater) &&
            Objects.equals(this.operaterid, msOperateRoleUserRelRequest.operaterid) &&
            Objects.equals(this.rid, msOperateRoleUserRelRequest.rid) &&
            Objects.equals(this.roleIds, msOperateRoleUserRelRequest.roleIds) &&
            Objects.equals(this.userId, msOperateRoleUserRelRequest.userId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, doType, groupId, operater, operaterid, rid, roleIds, userId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsOperateRoleUserRelRequest }.
     */
    public static MsOperateRoleUserRelRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsOperateRoleUserRelRequest.class);
    }
}

