package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.phoenix.ucenter.service.model.MsSysOrgUserRelDTO;
import org.yiwan.seiya.phoenix.ucenter.service.model.MsSysUserDTO;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsOperateUserRequest   {
    @JsonProperty("appid")
    private String appid = null;

  /**
   * 操作类型
   */
  public enum DoTypeEnum {
    I("I"),
    
    U("U"),
    
    D("D");

    private String value;

    DoTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DoTypeEnum fromValue(String text) {
      for (DoTypeEnum b : DoTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("doType")
    private DoTypeEnum doType = null;

    @JsonProperty("operater")
    private String operater = null;

    @JsonProperty("operaterid")
    private String operaterid = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("roleIds")
    private String roleIds = null;

    @JsonProperty("userInfo")
    private MsSysUserDTO userInfo = null;

    @JsonProperty("userOrgDTOs")
    @Valid
    private List<MsSysOrgUserRelDTO> userOrgDTOs = null;

    public MsOperateUserRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(value = "请求应用ID")


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsOperateUserRequest withDoType(DoTypeEnum doType) {
        this.doType = doType;
        return this;
    }

    /**
    * 操作类型
    * @return doType
    **/
    @ApiModelProperty(value = "操作类型")


    public DoTypeEnum getDoType() {
        return doType;
    }

    public void setDoType(DoTypeEnum doType) {
        this.doType = doType;
    }

    public MsOperateUserRequest withOperater(String operater) {
        this.operater = operater;
        return this;
    }

    /**
    * 操作人
    * @return operater
    **/
    @ApiModelProperty(value = "操作人")


    public String getOperater() {
        return operater;
    }

    public void setOperater(String operater) {
        this.operater = operater;
    }

    public MsOperateUserRequest withOperaterid(String operaterid) {
        this.operaterid = operaterid;
        return this;
    }

    /**
    * 操作人ID
    * @return operaterid
    **/
    @ApiModelProperty(value = "操作人ID")


    public String getOperaterid() {
        return operaterid;
    }

    public void setOperaterid(String operaterid) {
        this.operaterid = operaterid;
    }

    public MsOperateUserRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsOperateUserRequest withRoleIds(String roleIds) {
        this.roleIds = roleIds;
        return this;
    }

    /**
    * 角色id集合
    * @return roleIds
    **/
    @ApiModelProperty(value = "角色id集合")


    public String getRoleIds() {
        return roleIds;
    }

    public void setRoleIds(String roleIds) {
        this.roleIds = roleIds;
    }

    public MsOperateUserRequest withUserInfo(MsSysUserDTO userInfo) {
        this.userInfo = userInfo;
        return this;
    }

    /**
    * Get userInfo
    * @return userInfo
    **/
    @ApiModelProperty(value = "")

  @Valid

    public MsSysUserDTO getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(MsSysUserDTO userInfo) {
        this.userInfo = userInfo;
    }

    public MsOperateUserRequest withUserOrgDTOs(List<MsSysOrgUserRelDTO> userOrgDTOs) {
        this.userOrgDTOs = userOrgDTOs;
        return this;
    }

    public MsOperateUserRequest withUserOrgDTOsAdd(MsSysOrgUserRelDTO userOrgDTOs) {
        if (this.userOrgDTOs == null) {
            this.userOrgDTOs = new ArrayList<MsSysOrgUserRelDTO>();
        }
        this.userOrgDTOs.add(userOrgDTOs);
        return this;
    }

    /**
    * Get userOrgDTOs
    * @return userOrgDTOs
    **/
    @ApiModelProperty(value = "")

  @Valid

    public List<MsSysOrgUserRelDTO> getUserOrgDTOs() {
        return userOrgDTOs;
    }

    public void setUserOrgDTOs(List<MsSysOrgUserRelDTO> userOrgDTOs) {
        this.userOrgDTOs = userOrgDTOs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsOperateUserRequest msOperateUserRequest = (MsOperateUserRequest) o;
        return Objects.equals(this.appid, msOperateUserRequest.appid) &&
            Objects.equals(this.doType, msOperateUserRequest.doType) &&
            Objects.equals(this.operater, msOperateUserRequest.operater) &&
            Objects.equals(this.operaterid, msOperateUserRequest.operaterid) &&
            Objects.equals(this.rid, msOperateUserRequest.rid) &&
            Objects.equals(this.roleIds, msOperateUserRequest.roleIds) &&
            Objects.equals(this.userInfo, msOperateUserRequest.userInfo) &&
            Objects.equals(this.userOrgDTOs, msOperateUserRequest.userOrgDTOs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, doType, operater, operaterid, rid, roleIds, userInfo, userOrgDTOs);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsOperateUserRequest }.
     */
    public static MsOperateUserRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsOperateUserRequest.class);
    }
}

