package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.phoenix.ucenter.service.model.MsOrgTree;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * null
 */
@ApiModel(description = "null")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsOrgTree   {
    @JsonProperty("auditStatus")
    private Integer auditStatus = null;

    @JsonProperty("companyId")
    private Long companyId = null;

    @JsonProperty("createTime")
    private String createTime = null;

    @JsonProperty("createUserId")
    private String createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("entityFlg")
    private Integer entityFlg = null;

    @JsonProperty("groupId")
    private Long groupId = null;

    @JsonProperty("orgAddr")
    private String orgAddr = null;

    @JsonProperty("orgCode")
    private String orgCode = null;

    @JsonProperty("orgDesc")
    private String orgDesc = null;

    @JsonProperty("orgLevel")
    private Long orgLevel = null;

    @JsonProperty("orgName")
    private String orgName = null;

    @JsonProperty("orgStructId")
    private Long orgStructId = null;

    @JsonProperty("orgType")
    private Integer orgType = null;

    @JsonProperty("parentId")
    private Long parentId = null;

    @JsonProperty("status")
    private Integer status = null;

    @JsonProperty("subOrgTrees")
    @Valid
    private List<MsOrgTree> subOrgTrees = null;

    @JsonProperty("taxpayerType")
    private Integer taxpayerType = null;

    @JsonProperty("unCreditCode")
    private String unCreditCode = null;

    @JsonProperty("updateTime")
    private String updateTime = null;

    @JsonProperty("updateUserId")
    private String updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    public MsOrgTree withAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
        return this;
    }

    /**
    * 公司审核状态：0待审核，1审核通过,2审核失败
    * @return auditStatus
    **/
    @ApiModelProperty(value = "公司审核状态：0待审核，1审核通过,2审核失败")


    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public MsOrgTree withCompanyId(Long companyId) {
        this.companyId = companyId;
        return this;
    }

    /**
    * 公司ID
    * @return companyId
    **/
    @ApiModelProperty(value = "公司ID")


    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public MsOrgTree withCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
    * 创建时间
    * @return createTime
    **/
    @ApiModelProperty(value = "创建时间")


    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public MsOrgTree withCreateUserId(String createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
    * 创建人ID
    * @return createUserId
    **/
    @ApiModelProperty(value = "创建人ID")


    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public MsOrgTree withCreateUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
    * 创建人姓名
    * @return createUserName
    **/
    @ApiModelProperty(value = "创建人姓名")


    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public MsOrgTree withEntityFlg(Integer entityFlg) {
        this.entityFlg = entityFlg;
        return this;
    }

    /**
    * 是否实体公司 1：是 0：否
    * @return entityFlg
    **/
    @ApiModelProperty(value = "是否实体公司 1：是 0：否")


    public Integer getEntityFlg() {
        return entityFlg;
    }

    public void setEntityFlg(Integer entityFlg) {
        this.entityFlg = entityFlg;
    }

    public MsOrgTree withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团ID
    * @return groupId
    **/
    @ApiModelProperty(value = "集团ID")


    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public MsOrgTree withOrgAddr(String orgAddr) {
        this.orgAddr = orgAddr;
        return this;
    }

    /**
    * 注册地址
    * @return orgAddr
    **/
    @ApiModelProperty(value = "注册地址")


    public String getOrgAddr() {
        return orgAddr;
    }

    public void setOrgAddr(String orgAddr) {
        this.orgAddr = orgAddr;
    }

    public MsOrgTree withOrgCode(String orgCode) {
        this.orgCode = orgCode;
        return this;
    }

    /**
    * 组织代码
    * @return orgCode
    **/
    @ApiModelProperty(value = "组织代码")


    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public MsOrgTree withOrgDesc(String orgDesc) {
        this.orgDesc = orgDesc;
        return this;
    }

    /**
    * 组织备注
    * @return orgDesc
    **/
    @ApiModelProperty(value = "组织备注")


    public String getOrgDesc() {
        return orgDesc;
    }

    public void setOrgDesc(String orgDesc) {
        this.orgDesc = orgDesc;
    }

    public MsOrgTree withOrgLevel(Long orgLevel) {
        this.orgLevel = orgLevel;
        return this;
    }

    /**
    * 层级 根节点=0
    * @return orgLevel
    **/
    @ApiModelProperty(value = "层级 根节点=0")


    public Long getOrgLevel() {
        return orgLevel;
    }

    public void setOrgLevel(Long orgLevel) {
        this.orgLevel = orgLevel;
    }

    public MsOrgTree withOrgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    /**
    * 组织名称
    * @return orgName
    **/
    @ApiModelProperty(value = "组织名称")


    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public MsOrgTree withOrgStructId(Long orgStructId) {
        this.orgStructId = orgStructId;
        return this;
    }

    /**
    * 自增主键
    * @return orgStructId
    **/
    @ApiModelProperty(value = "自增主键")


    public Long getOrgStructId() {
        return orgStructId;
    }

    public void setOrgStructId(Long orgStructId) {
        this.orgStructId = orgStructId;
    }

    public MsOrgTree withOrgType(Integer orgType) {
        this.orgType = orgType;
        return this;
    }

    /**
    * 组织类型 0；集团 1：公司 2：其他组织
    * @return orgType
    **/
    @ApiModelProperty(value = "组织类型 0；集团 1：公司 2：其他组织")


    public Integer getOrgType() {
        return orgType;
    }

    public void setOrgType(Integer orgType) {
        this.orgType = orgType;
    }

    public MsOrgTree withParentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    /**
    * 上级组织 根节点=0
    * @return parentId
    **/
    @ApiModelProperty(value = "上级组织 根节点=0")


    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public MsOrgTree withStatus(Integer status) {
        this.status = status;
        return this;
    }

    /**
    * 启用状态： 1 启用 0 注销
    * @return status
    **/
    @ApiModelProperty(value = "启用状态： 1 启用 0 注销")


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public MsOrgTree withSubOrgTrees(List<MsOrgTree> subOrgTrees) {
        this.subOrgTrees = subOrgTrees;
        return this;
    }

    public MsOrgTree withSubOrgTreesAdd(MsOrgTree subOrgTrees) {
        if (this.subOrgTrees == null) {
            this.subOrgTrees = new ArrayList<MsOrgTree>();
        }
        this.subOrgTrees.add(subOrgTrees);
        return this;
    }

    /**
    * 组织子树
    * @return subOrgTrees
    **/
    @ApiModelProperty(value = "组织子树")

  @Valid

    public List<MsOrgTree> getSubOrgTrees() {
        return subOrgTrees;
    }

    public void setSubOrgTrees(List<MsOrgTree> subOrgTrees) {
        this.subOrgTrees = subOrgTrees;
    }

    public MsOrgTree withTaxpayerType(Integer taxpayerType) {
        this.taxpayerType = taxpayerType;
        return this;
    }

    /**
    * 纳税人类型 0：小规模纳税人；1：一般纳税人
    * @return taxpayerType
    **/
    @ApiModelProperty(value = "纳税人类型 0：小规模纳税人；1：一般纳税人")


    public Integer getTaxpayerType() {
        return taxpayerType;
    }

    public void setTaxpayerType(Integer taxpayerType) {
        this.taxpayerType = taxpayerType;
    }

    public MsOrgTree withUnCreditCode(String unCreditCode) {
        this.unCreditCode = unCreditCode;
        return this;
    }

    /**
    * 统一信用代码
    * @return unCreditCode
    **/
    @ApiModelProperty(value = "统一信用代码")


    public String getUnCreditCode() {
        return unCreditCode;
    }

    public void setUnCreditCode(String unCreditCode) {
        this.unCreditCode = unCreditCode;
    }

    public MsOrgTree withUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
    * 更新时间
    * @return updateTime
    **/
    @ApiModelProperty(value = "更新时间")


    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public MsOrgTree withUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
        return this;
    }

    /**
    * 更新人ID
    * @return updateUserId
    **/
    @ApiModelProperty(value = "更新人ID")


    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    public MsOrgTree withUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
        return this;
    }

    /**
    * 更新人姓名
    * @return updateUserName
    **/
    @ApiModelProperty(value = "更新人姓名")


    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsOrgTree msOrgTree = (MsOrgTree) o;
        return Objects.equals(this.auditStatus, msOrgTree.auditStatus) &&
            Objects.equals(this.companyId, msOrgTree.companyId) &&
            Objects.equals(this.createTime, msOrgTree.createTime) &&
            Objects.equals(this.createUserId, msOrgTree.createUserId) &&
            Objects.equals(this.createUserName, msOrgTree.createUserName) &&
            Objects.equals(this.entityFlg, msOrgTree.entityFlg) &&
            Objects.equals(this.groupId, msOrgTree.groupId) &&
            Objects.equals(this.orgAddr, msOrgTree.orgAddr) &&
            Objects.equals(this.orgCode, msOrgTree.orgCode) &&
            Objects.equals(this.orgDesc, msOrgTree.orgDesc) &&
            Objects.equals(this.orgLevel, msOrgTree.orgLevel) &&
            Objects.equals(this.orgName, msOrgTree.orgName) &&
            Objects.equals(this.orgStructId, msOrgTree.orgStructId) &&
            Objects.equals(this.orgType, msOrgTree.orgType) &&
            Objects.equals(this.parentId, msOrgTree.parentId) &&
            Objects.equals(this.status, msOrgTree.status) &&
            Objects.equals(this.subOrgTrees, msOrgTree.subOrgTrees) &&
            Objects.equals(this.taxpayerType, msOrgTree.taxpayerType) &&
            Objects.equals(this.unCreditCode, msOrgTree.unCreditCode) &&
            Objects.equals(this.updateTime, msOrgTree.updateTime) &&
            Objects.equals(this.updateUserId, msOrgTree.updateUserId) &&
            Objects.equals(this.updateUserName, msOrgTree.updateUserName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(auditStatus, companyId, createTime, createUserId, createUserName, entityFlg, groupId, orgAddr, orgCode, orgDesc, orgLevel, orgName, orgStructId, orgType, parentId, status, subOrgTrees, taxpayerType, unCreditCode, updateTime, updateUserId, updateUserName);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsOrgTree }.
     */
    public static MsOrgTree fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsOrgTree.class);
    }
}

