/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.phoenix.web.bss.pages;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import org.openqa.selenium.By;
import org.yiwan.seiya.phoenix.web.bss.pages.NavigationBar;
import org.yiwan.seiya.phoenix.web.bss.pojos.TenantAccount;
import org.yiwan.seiya.phoenix.web.bss.pojos.TenantAccountSearchCondition;
import org.yiwan.seiya.phoenix.web.bss.pojos.TenantAccountSearchResult;

public class TenantAccountPage
extends NavigationBar {
    public static void passToInputTenantInformation() {
        Selenide.$((By)By.xpath((String)"//span[text()='\u65b0\u5efa']//parent::button")).click();
    }

    public static void inputTenantInformation(TenantAccount tenantAccount) {
        if (tenantAccount.getTenantEmail() != null) {
            Selenide.$((String)"#tenantEmail").sendKeys(new CharSequence[]{tenantAccount.getTenantEmail()});
        }
        if (tenantAccount.getTenantPhone() != null) {
            Selenide.$((String)"#tenantPhone").sendKeys(new CharSequence[]{tenantAccount.getTenantPhone()});
        }
    }

    public static void passToInputCompanyInformation() {
        Selenide.$((By)By.xpath((String)"//span[text()='\u4e0b\u4e00\u6b65']/parent::button")).click();
    }

    public static void inputCompanyInformation(TenantAccount tenantAccount) {
        if (tenantAccount.getCompanyName() != null) {
            Selenide.$((String)"#companyName").sendKeys(new CharSequence[]{tenantAccount.getCompanyName()});
        }
        if (tenantAccount.getCompanyPhone() != null) {
            Selenide.$((String)"#companyTel").sendKeys(new CharSequence[]{tenantAccount.getCompanyPhone()});
        }
        if (tenantAccount.getTenantName() != null) {
            Selenide.$((String)"#contactName").sendKeys(new CharSequence[]{tenantAccount.getTenantName()});
        }
        if (tenantAccount.getCompanyAddress() != null) {
            Selenide.$((String)"#companyAddr").sendKeys(new CharSequence[]{tenantAccount.getCompanyAddress()});
        }
    }

    public static void passToFinishTenantCreation() {
        Selenide.$((By)By.xpath((String)"//span[text()='\u4e0b\u4e00\u6b65']/parent::button")).click();
    }

    public static void assertTenantCreationStatus(String tenantEmail, String status) {
        String xpath = "//div[starts-with(text(),'\u8d26\u6237\uff1a')]";
        Selenide.$((By)By.xpath((String)xpath)).shouldBe(new Condition[]{Condition.visible});
    }

    public static void backToTenantList() {
        Selenide.$((String)"//span[text()='\u786e \u5b9a']//parent::button").click();
    }

    public static void continueToAddTenant() {
        Selenide.$((String)"//span[text()='\u7ee7\u7eed\u6dfb\u52a0']//parent::button").click();
    }

    public static void inputTenantAccountSearch(TenantAccountSearchCondition tenantAccountSearchCondition) {
        if (tenantAccountSearchCondition.getTenantEmail() != null) {
            Selenide.$((By)By.xpath((String)"//span[text()='\u8d26\u53f7\u540d\u79f0']/input")).sendKeys(new CharSequence[]{tenantAccountSearchCondition.getTenantEmail()});
        }
        if (tenantAccountSearchCondition.getTenantStatus() != null) {
            Selenide.$((By)By.xpath((String)"//span[text()='\u72b6\u6001']//div[@aria-expanded='false']")).click();
            String xpath = String.format("//ul[li='%s']", tenantAccountSearchCondition.getTenantStatus());
            Selenide.$((By)By.xpath((String)xpath)).click();
        }
    }

    public static void searchTenantAccount() {
        Selenide.$((By)By.xpath((String)"//span[text()='\u67e5 \u8be2']/parent::button")).click();
    }

    public static void shouldHaveTenantInSearchResultTable(TenantAccountSearchResult tenantAccountSearchResult) {
        String xpath = "//tr";
        if (tenantAccountSearchResult.getTenantEmail() != null) {
            xpath = xpath + String.format("[td='%s']", tenantAccountSearchResult.getTenantEmail());
        }
        if (tenantAccountSearchResult.getTenantGroupName() != null) {
            xpath = xpath + String.format("[td//div='%s']", tenantAccountSearchResult.getTenantGroupName());
        }
        if (tenantAccountSearchResult.getTenantStatus() != null) {
            xpath = xpath + String.format("[td//span='%s']", tenantAccountSearchResult.getTenantStatus());
        }
        Selenide.$((By)By.xpath((String)xpath)).shouldBe(new Condition[]{Condition.visible});
    }
}

