/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.phoenix.web.glue.hooks;

import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import cucumber.api.Scenario;
import cucumber.api.java.After;
import cucumber.api.java.Before;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.yiwan.seiya.core.util.ApplicationContextContainer;
import org.yiwan.seiya.phoenix.web.util.CucumberScenarioContainer;

public class CucumberHooks {
    private static final Logger logger = LoggerFactory.getLogger(CucumberHooks.class);
    private static final String FEATURE_DIRECOTRY_NAME = "features";
    private static final String DISCRIMINATOR_KEY = "scenario";
    private static final String LOG_HOME = "target/test-results/logs";

    @Before
    public void beforeScenario(Scenario scenario) {
        CucumberScenarioContainer.setScenario(scenario);
        String scenarioName = scenario.getName();
        MDC.put((String)DISCRIMINATOR_KEY, (String)scenarioName);
        String featureUri = scenario.getUri();
        String featureUriWithoutSuffix = StringUtils.removeEndIgnoreCase((String)featureUri, (String)".feature");
        String featureUriWithSameSpliter = StringUtils.replace((String)featureUriWithoutSuffix, (String)"\\", (String)File.separator);
        String featureUriAfterFeatureDirectory = StringUtils.substringAfter((String)featureUriWithSameSpliter, (String)FEATURE_DIRECOTRY_NAME);
        String contextUri = "classpath:features" + File.separator + "**" + featureUriAfterFeatureDirectory + File.separator + scenarioName + ".xml";
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(contextUri);
        ApplicationContextContainer.setApplicationContext((ApplicationContext)applicationContext);
        this.handleInternetExplorerSetup();
    }

    @After
    public void afterScenario(Scenario scenario) {
        if (scenario.isFailed()) {
            this.embedScreenshot(scenario);
            this.embedLog(scenario);
        }
        Selenide.close();
        this.handleInternetExplorerTeardown();
    }

    private void embedScreenshot(Scenario scenario) {
        String fileName = Selenide.screenshot((String)scenario.getName());
        byte[] screenshot = new byte[]{};
        try {
            screenshot = FileUtils.readFileToByteArray((File)new File(fileName));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        scenario.embed(screenshot, "image/png");
    }

    private void embedLog(Scenario scenario) {
        String text = "";
        try {
            text = FileUtils.readFileToString((File)new File(LOG_HOME, MDC.get((String)DISCRIMINATOR_KEY) + ".log"), (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        scenario.write(text);
    }

    private void embedHtml(Scenario scenario, String html) {
        scenario.embed(html.getBytes(Charset.defaultCharset()), "text/html");
    }

    private void embedParagraph(Scenario scenario, String text) {
        scenario.write("\n<p>\n" + text + "</p>");
    }

    private void embedXml(Scenario scenario, String text) {
        scenario.write("\n<xmp>\n" + text + "</xmp>");
    }

    private void handleInternetExplorerSetup() {
        if (WebDriverRunner.isIE()) {
            WebDriverRunner.clearBrowserCache();
        }
    }

    private void handleInternetExplorerTeardown() {
        if (WebDriverRunner.isIE()) {
            WebDriverRunner.clearBrowserCache();
        }
    }
}

