/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.tower.test;

import com.google.common.collect.ImmutableMap;
import io.qameta.allure.Allure;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.config.LogConfig;
import io.restassured.filter.log.LogDetail;
import io.restassured.http.ContentType;
import io.restassured.parsing.Parser;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.yiwan.seiya.tower.test.config.TestConfig;

@ContextConfiguration(classes={TestConfig.class})
public abstract class AbstractTowerTestNGSpringTests
extends AbstractTestNGSpringContextTests {
    private static final Logger log = LoggerFactory.getLogger(AbstractTowerTestNGSpringTests.class);
    private static final String SIFTING_KEY = "ClassAndMethodName";
    private static final String USER_CENTER_LOGIN_URL = "/client/login";
    private static final String TOKEN_HEADER_NAME = "x-app-token";
    private static final String CLIENT_ID = "clientId";
    private static final String SECRET = "secret";
    protected static final String CODE = "code";
    protected RequestSpecification requestSpec;
    protected RequestSpecBuilder requestSpecBuilder;
    protected ResponseSpecification responseSpec;
    protected ResponseSpecBuilder responseSpecBuilder;
    private File logFile;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private TestConfig testConfig;
    private Boolean enableGateway;
    private Boolean enableDatabaseOperation;

    public abstract String getBaseURI();

    public abstract Integer getPort();

    public abstract String getBasePath();

    public <T> T getBean(String beanName) {
        return (T)this.applicationContext.getBean(beanName);
    }

    public <T> T createBean(Class<T> clazz) {
        return (T)this.applicationContext.getAutowireCapableBeanFactory().createBean(clazz);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) {
        return this.applicationContext.getBeansOfType(type);
    }

    public String getMessage(String key) {
        return this.applicationContext.getMessage(key, null, Locale.getDefault());
    }

    public String[] getActiveProfiles() {
        return this.applicationContext.getEnvironment().getActiveProfiles();
    }

    public String getActiveProfile() {
        Object[] activeProfiles = this.getActiveProfiles();
        if (activeProfiles.length != 1) {
            throw new RuntimeException("invalid active profiles " + Arrays.toString(activeProfiles));
        }
        return activeProfiles[0];
    }

    public boolean isEnableGateway() {
        if (null == this.enableGateway) {
            String activeProfile = this.getActiveProfile();
            this.enableGateway = StringUtils.equalsAnyIgnoreCase((CharSequence)activeProfile, (CharSequence[])this.testConfig.getGatewayEnabledProfiles());
        }
        return this.enableGateway;
    }

    public boolean isEnableDatabaseOperation() {
        if (this.enableDatabaseOperation.booleanValue()) {
            String activeProfile = this.getActiveProfile();
            this.enableDatabaseOperation = StringUtils.equalsAnyIgnoreCase((CharSequence)activeProfile, (CharSequence[])this.testConfig.getDatabaseOperationEnabledProfiles());
        }
        return this.enableDatabaseOperation;
    }

    private void refreshSiftingAppender(ITestResult testResult) {
        MDC.put((String)SIFTING_KEY, (String)(((Object)((Object)this)).getClass().getSimpleName() + File.separator + testResult.getMethod().getMethodName()));
    }

    private void resetSiftingAppender() {
        MDC.remove((String)SIFTING_KEY);
    }

    private void logRestAssuredOutput(ITestResult testResult) throws IOException {
        File logFolder = new File("target/logs/", ((Object)((Object)this)).getClass().getSimpleName());
        logFolder.mkdirs();
        this.logFile = new File(logFolder, testResult.getMethod().getMethodName() + ".log");
        FileWriter fileWriter = new FileWriter(this.logFile, true);
        PrintStream printStream = new PrintStream((OutputStream)new WriterOutputStream((Writer)fileWriter, Charsets.UTF_8), true);
        RestAssured.config = RestAssured.config().logConfig(LogConfig.logConfig().defaultStream(printStream));
    }

    protected void buildRequestSpec() {
        this.requestSpecBuilder = new RequestSpecBuilder();
        this.requestSpecBuilder.setAccept(ContentType.JSON.withCharset(Charset.forName("UTF-8")));
        this.requestSpecBuilder.setContentType(ContentType.JSON.withCharset(Charset.forName("UTF-8")));
        this.requestSpecBuilder.setBaseUri(this.getBaseURI());
        this.requestSpecBuilder.setPort(this.getPort().intValue());
        this.requestSpecBuilder.setBasePath(this.getBasePath());
        this.requestSpecBuilder.log(LogDetail.ALL);
        this.requestSpec = this.requestSpecBuilder.build();
    }

    protected void buildResponseSpec() {
        this.responseSpecBuilder = new ResponseSpecBuilder();
        this.responseSpecBuilder.log(LogDetail.ALL);
        this.responseSpec = this.responseSpecBuilder.build();
    }

    private void addAllureAttachment(File file) throws IOException {
        Allure.addAttachment((String)"test log", (String)FileUtils.readFileToString((File)file, (Charset)Charsets.UTF_8));
    }

    private String obtainGatewayToken() {
        ImmutableMap map = ImmutableMap.of((Object)CLIENT_ID, (Object)this.testConfig.getGatewayClientId(), (Object)SECRET, (Object)this.testConfig.getGatewaySecret());
        return (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().spec(this.requestSpec).body((Object)map).when().post(USER_CENTER_LOGIN_URL, new Object[0])).then()).spec(this.responseSpec)).statusCode(200)).body(CODE, Matchers.equalTo((Object)1), new Object[0])).extract().path("data", new String[0]);
    }

    @BeforeClass
    public void beforeClass() {
        this.resetSiftingAppender();
        RestAssured.defaultParser = Parser.JSON;
        this.buildRequestSpec();
        this.buildResponseSpec();
        if (this.isEnableGateway()) {
            String token = this.obtainGatewayToken();
            this.requestSpecBuilder.addHeader(TOKEN_HEADER_NAME, token);
            this.requestSpec = this.requestSpecBuilder.build();
        }
    }

    @AfterClass
    public void afterClass() {
        RestAssured.reset();
    }

    @BeforeMethod
    public void beforeMethod(ITestContext testContext, ITestResult testResult) throws IOException {
        this.refreshSiftingAppender(testResult);
        this.logRestAssuredOutput(testResult);
    }

    @AfterMethod
    public void afterMethod(ITestContext testContext, ITestResult testResult) throws IOException {
        if (testResult.getStatus() != 1 && testResult.getThrowable() != null) {
            log.error(testResult.getThrowable().getMessage(), testResult.getThrowable());
            this.addAllureAttachment(this.logFile);
        }
    }
}

