/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.swagger.testcodegen.plugin;

import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerCompatConverter;
import io.swagger.parser.SwaggerParser;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;

public abstract class AbstractSeiyaSwaggerTestcodegenMojo
extends AbstractMojo {
    static boolean allowUnicodeIdentifiers = false;
    static final String SWAGGER_VERSION_V2 = "2.0";
    static final String TEST_CODEGEN_TEMPLATE = "test-codegen-template.vm";
    static final String TEST_DATA_TEMPLATE = "test-data-template.xml";
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    MavenProject project;
    @Parameter(defaultValue="false")
    Boolean skip;
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    File sourceDir;
    @Parameter(defaultValue="${project.basedir}/src/test/resources")
    File resourceDir;
    @Parameter(required=true)
    String inputSpec;
    @Parameter(defaultValue="false")
    Boolean override;
    @Parameter(defaultValue="2.0")
    String swaggerVersion;
    @Parameter(required=true)
    String classPackage;
    @Parameter(required=true)
    String apiPackage;
    @Parameter
    String superClass;
    @Parameter(required=true)
    String appid;
    @Parameter(defaultValue="mybatis")
    String ormType;
    @Parameter(defaultValue="testng")
    String framework;
    @Parameter(defaultValue="UTF-8")
    String encoding;
    @Parameter(defaultValue="allure")
    String reportType;
    Template velocityTemplate;

    static void createDirectoryIfRequired(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    static String getLastString(String[] strings) {
        return AbstractSeiyaSwaggerTestcodegenMojo.getString(strings, -1);
    }

    static String getString(String[] strings, int offset) {
        return strings[strings.length + offset];
    }

    Swagger getSwagger(String inputSpec) {
        Swagger swagger = null;
        if (SWAGGER_VERSION_V2.equals(this.swaggerVersion)) {
            SwaggerParser swaggerParser = new SwaggerParser();
            swagger = swaggerParser.read(inputSpec, null, true);
        } else {
            SwaggerCompatConverter swaggerCompatConverter = new SwaggerCompatConverter();
            try {
                swagger = swaggerCompatConverter.read(inputSpec, null);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"cannot read api-doc from spec[version_v1.x]", (Throwable)e);
            }
        }
        return swagger;
    }

    String camelize(String word) {
        return this.camelize(word, false);
    }

    String camelize(String word, boolean lowercaseFirstLetter) {
        Pattern p = Pattern.compile("[/\\- ](.?)");
        Matcher m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("." + m.group(1));
            m = p.matcher(word);
        }
        String[] parts = word.split("\\.");
        StringBuilder f = new StringBuilder();
        for (String z : parts) {
            if (z.length() <= 0) continue;
            f.append(Character.toUpperCase(z.charAt(0))).append(z.substring(1));
        }
        word = f.toString();
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("" + Character.toUpperCase(m.group(1).charAt(0)) + m.group(1).substring(1));
            m = p.matcher(word);
        }
        p = Pattern.compile("(\\.?)(\\w)([^\\.]*)$");
        m = p.matcher(word);
        if (m.find()) {
            String rep = m.group(1) + m.group(2).toUpperCase() + m.group(3);
            rep = rep.replaceAll("\\$", "\\\\\\$");
            word = m.replaceAll(rep);
        }
        p = Pattern.compile("(_)(.)");
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst(m.group(2).toUpperCase());
            m = p.matcher(word);
        }
        if (lowercaseFirstLetter && word.length() > 0) {
            word = word.substring(0, 1).toLowerCase() + word.substring(1);
        }
        return word;
    }

    String underscore(String word) {
        String firstPattern = "([A-Z]+)([A-Z][a-z])";
        String secondPattern = "([a-z\\d])([A-Z])";
        String replacementPattern = "$1_$2";
        word = word.replaceAll("\\.", "/");
        word = word.replaceAll("\\$", "__");
        word = word.replaceAll(firstPattern, replacementPattern);
        word = word.replaceAll(secondPattern, replacementPattern);
        word = word.replace('-', '_');
        word = word.toLowerCase();
        return word;
    }

    String sanitizeName(String name) {
        if (name == null) {
            this.getLog().error((CharSequence)"String to be sanitized is null. Default to ERROR_UNKNOWN");
            return "ERROR_UNKNOWN";
        }
        if ("$".equals(name)) {
            return "value";
        }
        name = name.replaceAll("\\[\\]", "");
        name = name.replaceAll("\\[", "_");
        name = name.replaceAll("\\]", "");
        name = name.replaceAll("\\(", "_");
        name = name.replaceAll("\\)", "");
        name = name.replaceAll("\\.", "_");
        name = name.replaceAll("-", "_");
        name = name.replaceAll(" ", "_");
        name = allowUnicodeIdentifiers ? Pattern.compile("\\W", 256).matcher(name).replaceAll("") : name.replaceAll("\\W", "");
        return name;
    }
}

