/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.swagger.testcodegen.plugin;

import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.yiwan.seiya.swagger.testcodegen.plugin.AbstractSeiyaSwaggerTestcodegenMojo;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class SeiyaSwaggerTestcodegenMojo
extends AbstractSeiyaSwaggerTestcodegenMojo {
    public void execute() throws MojoExecutionException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"swagger test code generation is skipped.");
            return;
        }
        Swagger swagger = this.getSwagger(this.inputSpec);
        Map swaggerPathMap = swagger.getPaths();
        this.initTemplate();
        this.generateSwaggerTestCode(swaggerPathMap);
        this.project.addCompileSourceRoot(this.sourceDir.getAbsolutePath());
    }

    private void initTemplate() {
        Properties props = new Properties();
        props.put("resource.loader", "class");
        props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        VelocityEngine engine = new VelocityEngine(props);
        engine.init();
        this.velocityTemplate = engine.getTemplate("test-codegen-template.vm", this.encoding);
    }

    private void generateSwaggerTestCode(Map<String, Path> swaggerPathMap) throws MojoExecutionException {
        String superClassName = null;
        if (this.superClass != null) {
            String[] superClassSplits = this.superClass.split("\\.");
            superClassName = SeiyaSwaggerTestcodegenMojo.getLastString(superClassSplits);
        }
        String output = this.sourceDir.getAbsolutePath() + File.separator + StringUtils.replace((String)this.classPackage, (String)".", (String)File.separator);
        File outputDir = new File(output);
        SeiyaSwaggerTestcodegenMojo.createDirectoryIfRequired(outputDir);
        SeiyaSwaggerTestcodegenMojo.createDirectoryIfRequired(this.resourceDir);
        String testData = null;
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-data-template.xml");){
            testData = IOUtils.toString((InputStream)inputStream, (String)this.encoding);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error on reading file test-data-template.xml", (Exception)e);
        }
        for (Map.Entry<String, Path> entry : swaggerPathMap.entrySet()) {
            this.getLog().debug((CharSequence)("entry path = " + entry.getKey()));
            Map operationMap = entry.getValue().getOperationMap();
            for (Map.Entry operationEntry : operationMap.entrySet()) {
                String apiClassName;
                Object camelizedTag;
                HttpMethod httpMethod = (HttpMethod)operationEntry.getKey();
                String action = httpMethod.name().toLowerCase();
                Operation operation = (Operation)operationEntry.getValue();
                String operationId = operation.getOperationId();
                if (StringUtils.isEmpty((CharSequence)operationId)) {
                    operationId = RandomStringUtils.randomAlphabetic((int)10).toLowerCase();
                }
                String apiName = this.underscore(this.sanitizeName(operationId)).toUpperCase();
                String testClassName = String.format("%sTest", this.camelize(operationId));
                String outputFileName = String.format("%s.java", testClassName);
                String resourceFileName = String.format("%s.xml", testClassName);
                List tags = operation.getTags();
                if (tags.size() > 0) {
                    for (String tag : operation.getTags()) {
                        camelizedTag = this.camelize(tag);
                        String uncapitalizedTag = this.camelize(tag, true);
                        apiClassName = String.format("%sApi", camelizedTag);
                        File taggedOutput = new File(outputDir, uncapitalizedTag);
                        SeiyaSwaggerTestcodegenMojo.createDirectoryIfRequired(taggedOutput);
                        File taggedResourceDir = new File(this.resourceDir, uncapitalizedTag);
                        SeiyaSwaggerTestcodegenMojo.createDirectoryIfRequired(taggedResourceDir);
                        File outputFile = new File(taggedOutput, outputFileName);
                        if (this.override.booleanValue() || !outputFile.exists()) {
                            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.encoding));){
                                this.writeContent(bufferedWriter, String.format("%s.%s", this.classPackage, uncapitalizedTag), superClassName, testClassName, apiClassName, apiName, action, uncapitalizedTag);
                            }
                            catch (IOException e) {
                                throw new MojoExecutionException("Error on creating file " + outputFile, (Exception)e);
                            }
                        }
                        File resourceFile = new File(taggedResourceDir, resourceFileName);
                        if (!this.override.booleanValue() && resourceFile.exists()) continue;
                        try {
                            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(resourceFile), this.encoding));
                            Throwable throwable = null;
                            try {
                                bufferedWriter.write(testData);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (bufferedWriter == null) continue;
                                if (throwable != null) {
                                    try {
                                        bufferedWriter.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                bufferedWriter.close();
                            }
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException("Error on creating file " + resourceFile, (Exception)e);
                        }
                    }
                    continue;
                }
                apiClassName = "ApiApi";
                File outputFile = new File(output, outputFileName);
                if (this.override.booleanValue() || !outputFile.exists()) {
                    try {
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.encoding));
                        camelizedTag = null;
                        try {
                            this.writeContent(bufferedWriter, this.classPackage, superClassName, testClassName, apiClassName, apiName, action, null);
                        }
                        catch (Throwable throwable) {
                            camelizedTag = throwable;
                            throw throwable;
                        }
                        finally {
                            if (bufferedWriter != null) {
                                if (camelizedTag != null) {
                                    try {
                                        bufferedWriter.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)camelizedTag).addSuppressed(throwable);
                                    }
                                } else {
                                    bufferedWriter.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error on creating file " + outputFile, (Exception)e);
                    }
                }
                File resourceFile = new File(this.resourceDir, resourceFileName);
                if (!this.override.booleanValue() && resourceFile.exists()) continue;
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(resourceFile), this.encoding));
                    Throwable throwable = null;
                    try {
                        bufferedWriter.write(testData);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (bufferedWriter == null) continue;
                        if (throwable != null) {
                            try {
                                bufferedWriter.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        bufferedWriter.close();
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error on creating file " + resourceFile, (Exception)e);
                }
            }
        }
    }

    private void writeContent(Writer writer, String classPackage, String superClassName, String testClassName, String apiClassName, String apiName, String action, String tag) {
        VelocityContext context = new VelocityContext();
        context.put("classPackage", (Object)classPackage);
        context.put("superClass", (Object)this.superClass);
        context.put("superClassName", (Object)superClassName);
        context.put("testClassName", (Object)testClassName);
        context.put("apiPackage", (Object)this.apiPackage);
        context.put("apiClassName", (Object)apiClassName);
        context.put("apiName", (Object)apiName);
        context.put("appid", (Object)this.appid);
        context.put("action", (Object)action);
        context.put("ormType", (Object)this.ormType);
        context.put("tag", (Object)tag);
        context.put("framework", (Object)this.framework);
        context.put("reportType", (Object)this.reportType);
        this.velocityTemplate.merge((Context)context, writer);
    }
}

