package org.yiwan.seiya.mybatis.generator.codegen.mybatis3.javamapper.elements;

import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.dom.java.*;
import org.mybatis.generator.codegen.mybatis3.javamapper.elements.AbstractJavaMapperMethodGenerator;

import java.util.Set;
import java.util.TreeSet;

public class SeiyaJavaMapperMethodGenerator extends AbstractJavaMapperMethodGenerator {

    private static final String BASE_MAPPER = "org.yiwan.seiya.mybatis.extension.mapper.BaseMapper";

    @Override
    public void addInterfaceElements(Interface interfaze) {
        Set<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>(); // 创建importedTypes对象
        importedTypes.add(FullyQualifiedJavaType.getNewListInstance()); // 添加List的包
        FullyQualifiedJavaType baseRecordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType()); // 设置参数类型是对象
        importedTypes.add(baseRecordType); // import参数类型对象
        FullyQualifiedJavaType baseMapperType = new FullyQualifiedJavaType(BASE_MAPPER);
        importedTypes.add(baseMapperType);
        interfaze.addImportedTypes(importedTypes);
        FullyQualifiedJavaType integerType = new FullyQualifiedJavaType("java.lang.Integer");
        importedTypes.add(integerType);

        FullyQualifiedJavaType baseRecordListType = FullyQualifiedJavaType.getNewListInstance(); //baseRecordList
        baseRecordListType.addTypeArgument(baseRecordType); // 设置类型为List<T>

        FullyQualifiedJavaType objectistType = FullyQualifiedJavaType.getNewListInstance(); //baseRecordList
        objectistType.addTypeArgument(FullyQualifiedJavaType.getObjectInstance()); // 设置类型为List<Object>

        // add implemented interface
        FullyQualifiedJavaType superInterface = new FullyQualifiedJavaType(StringUtils.substringAfterLast(BASE_MAPPER, "."));
        superInterface.addTypeArgument(baseRecordType);
        interfaze.addSuperInterface(superInterface);

        addMethod(interfaze, integerType, "delete", baseRecordType, "record");
        addMethod(interfaze, integerType, "deleteAll", null, null);
        addMethod(interfaze, baseRecordListType, "selectAll", null, null);
        addMethod(interfaze, FullyQualifiedJavaType.getIntInstance(), "count", baseRecordType, "record");
        addMethod(interfaze, baseRecordType, "selectOne", baseRecordType, "record");
        addMethod(interfaze, baseRecordListType, "select", baseRecordType, "record");
        addMethod(interfaze, objectistType, "selectPkVals", baseRecordType, "record");
    }

    private void addMethod(Interface interfaze, FullyQualifiedJavaType returnType, String methodName, FullyQualifiedJavaType parameterType, String parameterName) {
        Method method = new Method(); // 创建方法对象
        method.setVisibility(JavaVisibility.PUBLIC); // 设置该方法为public
        method.setReturnType(returnType); // 方法对象设置返回类型对象
        method.setName(methodName); // 设置方法名称为我们在IntrospectedTable类中初始化的“delete”
        if (parameterType != null && parameterName != null) {
            method.addParameter(new Parameter(parameterType, parameterName)); // 为方法添加参数
        }
//        add method annotations
        if (introspectedTable.isJava5Targeted()) {
            method.addAnnotation("@Override"); //$NON-NLS-1$
        }
//        add method comments
        context.getCommentGenerator().addGeneralMethodComment(method, introspectedTable);
        if (context.getPlugins().clientSelectByPrimaryKeyMethodGenerated(method, interfaze, introspectedTable)) {
            interfaze.addMethod(method);
        }
    }

}
