package org.yiwan.seiya.mybatis.generator.codegen.mybatis3.xmlmapper.elements;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.codegen.mybatis3.xmlmapper.elements.AbstractXmlElementGenerator;
import org.mybatis.generator.internal.util.StringUtility;

public class SeiyaXmlElementGenerator extends AbstractXmlElementGenerator {

    private static final String BASE_COLUMNS = "Base_Column_List";
    private static final String WHERE_CLAUSE = "WHERE_CLAUSE";

    private static final TextElement SELECT_TEXT = new TextElement("select");
    private static final TextElement DELETE_TEXT = new TextElement("delete");
    private static final TextElement SELECT_COUNT_TEXT = new TextElement("select count(*)");

    private String tableName;
    private TextElement selectText;
    private TextElement deleteText;
    private TextElement countText;

    private XmlElement baseColumns;
    private TextElement fromClause;
    private XmlElement whereClause;

    @Override
    public void addElements(XmlElement parentElement) {
        addWhereClause(parentElement); // 添加where条件sql
        baseColumns = new XmlElement("include");
        baseColumns.addAttribute(new Attribute("refid", BASE_COLUMNS));

        tableName = introspectedTable.getFullyQualifiedTableNameAtRuntime();
        fromClause = new TextElement("from " + tableName);

        whereClause = new XmlElement("include");
        whereClause.addAttribute(new Attribute("refid", WHERE_CLAUSE));

        addDelete(parentElement); // 添加XML节点delete
        addDeleteAll(parentElement); // 添加XML节点delete
        addSelectAll(parentElement); // 添加XML节点selectAll
        addCount(parentElement); // 添加XML节点count
        addSelectOne(parentElement); // 添加XML节点selectOne
        addSelect(parentElement); // 添加XML节点select
        addSelectPkVals(parentElement);
    }

    private void addWhereClause(XmlElement parentElement) {
        XmlElement sqlElement = new XmlElement("sql");
        sqlElement.addAttribute(new Attribute("id", WHERE_CLAUSE));
        XmlElement whereElement = new XmlElement("where"); //设置where标签,和以下trim标签二选一
//        XmlElement where = new XmlElement("trim"); //设置trim标签
//        where.addAttribute(new Attribute("prefix", "WHERE"));
//        where.addAttribute(new Attribute("prefixOverrides", "AND | OR")); //添加where和and
        for (IntrospectedColumn introspectedColumn : introspectedTable.getAllColumns()) {
            XmlElement ifElement = new XmlElement("if"); //$NON-NLS-1$
            ifElement.addAttribute(new Attribute("test", "null != " + introspectedColumn.getJavaProperty()));
            ifElement.addElement(new TextElement("and "
                + MyBatis3FormattingUtilities.getEscapedColumnName(introspectedColumn)
                + " = "
                + MyBatis3FormattingUtilities.getParameterClause(introspectedColumn)));
            whereElement.addElement(ifElement);
        }
        sqlElement.addElement(whereElement);
        parentElement.addElement(sqlElement);
    }

    private void addDelete(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "delete"));
        xmlElement.addAttribute(new Attribute("parameterType", introspectedTable.getBaseRecordType()));
        xmlElement.addAttribute(new Attribute("resultType", "java.lang.Integer"));
        xmlElement.addElement(DELETE_TEXT);
        xmlElement.addElement(fromClause);
        xmlElement.addElement(whereClause);
        parentElement.addElement(xmlElement);
    }

    private void addDeleteAll(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "deleteAll"));
        xmlElement.addAttribute(new Attribute("parameterType", introspectedTable.getBaseRecordType()));
        xmlElement.addAttribute(new Attribute("resultType", "java.lang.Integer"));
        xmlElement.addElement(DELETE_TEXT);
        xmlElement.addElement(fromClause);
        parentElement.addElement(xmlElement);
    }

    private void addSelectAll(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "selectAll"));
        xmlElement.addAttribute(new Attribute("resultMap", "BaseResultMap"));
        xmlElement.addElement(SELECT_TEXT);
        xmlElement.addElement(baseColumns);
        xmlElement.addElement(fromClause);
        parentElement.addElement(xmlElement);
    }

    private void addCount(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "count"));
        xmlElement.addAttribute(new Attribute("parameterType", introspectedTable.getBaseRecordType()));
        xmlElement.addAttribute(new Attribute("resultType", "java.lang.Integer"));
        xmlElement.addElement(SELECT_COUNT_TEXT);
        xmlElement.addElement(fromClause);
        xmlElement.addElement(whereClause);
        parentElement.addElement(xmlElement);
    }

    private void addSelectOne(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "selectOne"));
        xmlElement.addAttribute(new Attribute("parameterType", introspectedTable.getBaseRecordType()));
        xmlElement.addAttribute(new Attribute("resultMap", "BaseResultMap"));
        xmlElement.addElement(SELECT_TEXT);
        xmlElement.addElement(baseColumns);
        xmlElement.addElement(fromClause);
        xmlElement.addElement(whereClause);
        parentElement.addElement(xmlElement);
    }

    private void addSelect(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "select"));
        xmlElement.addAttribute(new Attribute("parameterType", introspectedTable.getBaseRecordType()));
        xmlElement.addAttribute(new Attribute("resultMap", "BaseResultMap"));
        xmlElement.addElement(SELECT_TEXT);
        xmlElement.addElement(baseColumns);
        xmlElement.addElement(fromClause);
        xmlElement.addElement(whereClause);
        parentElement.addElement(xmlElement);
    }

    private void addSelectPkVals(XmlElement parentElement) {
        XmlElement xmlElement = new XmlElement("select");
        xmlElement.addAttribute(new Attribute("id", "selectPkVals"));
        xmlElement.addAttribute(new Attribute("parameterType", introspectedTable.getBaseRecordType()));
        xmlElement.addAttribute(new Attribute("resultType", "java.lang.Object"));
        xmlElement.addElement(SELECT_TEXT);

        StringBuilder sb = new StringBuilder();
        boolean and = false;
        for (IntrospectedColumn introspectedColumn : introspectedTable.getPrimaryKeyColumns()) {
            sb.setLength(0);
            if (and) {
                sb.append(","); //$NON-NLS-1$
            } else {
                and = true;
            }

            sb.append(MyBatis3FormattingUtilities.getAliasedEscapedColumnName(introspectedColumn));
            xmlElement.addElement(new TextElement(sb.toString()));
        }

        xmlElement.addElement(fromClause);
        xmlElement.addElement(whereClause);
        parentElement.addElement(xmlElement);
    }
}
