package org.yiwan.seiya.mybatis.generator.plugins;

import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.*;
import org.mybatis.generator.internal.util.StringUtility;

import java.util.List;

public class SeiyaActiveRecordPlugin extends PluginAdapter {

    private static final String BASE_ENTITY = "org.yiwan.seiya.mybatis.extension.entity.BaseEntity";

    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    @Override
    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        addSuperInterface(introspectedTable, topLevelClass);
        generateAutowiredMapperField(introspectedTable, topLevelClass);
        generateActiveRecordMethods(introspectedTable, topLevelClass);
        generatePkValMethod(introspectedTable, topLevelClass);
        return true;
    }

    @Override
    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        addSuperInterface(introspectedTable, topLevelClass);
        generateAutowiredMapperField(introspectedTable, topLevelClass);
        generateActiveRecordMethods(introspectedTable, topLevelClass);
        generatePkValMethod(introspectedTable, topLevelClass);
        return true;
    }

    @Override
    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        addSuperInterface(introspectedTable, topLevelClass);
        generateAutowiredMapperField(introspectedTable, topLevelClass);
        generateActiveRecordMethods(introspectedTable, topLevelClass);
        generatePkValMethod(introspectedTable, topLevelClass);
        return true;
    }

    private void addSuperInterface(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        topLevelClass.addImportedType(BASE_ENTITY);
        FullyQualifiedJavaType superInterface = new FullyQualifiedJavaType(BASE_ENTITY);
        FullyQualifiedJavaType baseRecordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        superInterface.addTypeArgument(baseRecordType);
        topLevelClass.addSuperInterface(superInterface);
    }

    private void generateAutowiredMapperField(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        String typeShortName = topLevelClass.getType().getShortName();
        topLevelClass.addImportedType("org.springframework.beans.factory.annotation.Autowired");
        String importedMapperType = String.format("%s.%sMapper", context.getJavaClientGeneratorConfiguration().getTargetPackage(), typeShortName);
        topLevelClass.addImportedType(importedMapperType);

        Field field = new Field();
        field.setFinal(false);
//        field.setInitializationString("1L"); //$NON-NLS-1$
        field.setName(String.format("%sMapper", StringUtils.uncapitalize(typeShortName))); //$NON-NLS-1$
        field.setStatic(false);
        field.setType(new FullyQualifiedJavaType(String.format("%sMapper", typeShortName))); //$NON-NLS-1$
        field.setVisibility(JavaVisibility.PRIVATE);
        field.addAnnotation("@Autowired");

        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3_DSQL) {
            context.getCommentGenerator().addFieldAnnotation(field, introspectedTable, topLevelClass.getImportedTypes());
        } else {
            context.getCommentGenerator().addFieldComment(field, introspectedTable);
        }

        topLevelClass.addField(field);
    }

    private void generateActiveRecordMethods(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        generateDeleteByPrimaryKey(introspectedTable, topLevelClass);
        generateInsert(introspectedTable, topLevelClass);
        generateInsertSelective(introspectedTable, topLevelClass);
        generateSelectByPrimaryKey(introspectedTable, topLevelClass);
        generateUpdateByPrimaryKeySelective(introspectedTable, topLevelClass);
        generateUpdateByPrimaryKey(introspectedTable, topLevelClass);
        generateDelete(introspectedTable, topLevelClass);
//        generateSelectAll(introspectedTable, topLevelClass);
        generateCount(introspectedTable, topLevelClass);
        generateSelectOne(introspectedTable, topLevelClass);
        generateSelect(introspectedTable, topLevelClass);
        generaterReplace(introspectedTable, topLevelClass);
        generaterReplaceSelective(introspectedTable, topLevelClass);
        generateSelectPkVals(introspectedTable, topLevelClass);
    }

    private Method generateActiveRecordMethod(TopLevelClass topLevelClass, IntrospectedTable introspectedTable, FullyQualifiedJavaType returnType, String methodName, String parameters) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(returnType);
        method.setName(methodName); //$NON-NLS-1$
        if (introspectedTable.isJava5Targeted()) {
            method.addAnnotation("@Override"); //$NON-NLS-1$
        }
        String bodyLine = String.format("return %sMapper.%s(%s);", StringUtils.uncapitalize(topLevelClass.getType().getShortName()), methodName, parameters);
        method.addBodyLine(bodyLine); //$NON-NLS-1$

        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3_DSQL) {
            context.getCommentGenerator().addGeneralMethodAnnotation(method, introspectedTable, topLevelClass.getImportedTypes());
        } else {
            context.getCommentGenerator().addGeneralMethodComment(method, introspectedTable);
        }

        return method;
    }

    private String generateParameters(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        List<IntrospectedColumn> introspectedColumns = introspectedTable.getPrimaryKeyColumns();
        String parameters = introspectedColumns.stream()
            .map(IntrospectedColumn::getJavaProperty)
            .reduce("", (a, b) -> a + ", " + b);
        return StringUtils.stripStart(parameters, ",").trim();
    }

    private void generateDeleteByPrimaryKey(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "deleteByPrimaryKey";
        String parameters = generateParameters(introspectedTable, topLevelClass);
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateInsert(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "insert";
        String parameters = "this";
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateInsertSelective(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "insertSelective";
        String paramters = "this";
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, paramters);
        topLevelClass.addMethod(method);
    }

    private void generateSelectByPrimaryKey(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        String methodName = "selectByPrimaryKey";
        String parameters = generateParameters(introspectedTable, topLevelClass);
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateUpdateByPrimaryKeySelective(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "updateByPrimaryKeySelective";
        String parameters = "this";
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateUpdateByPrimaryKey(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "updateByPrimaryKey";
        String parameters = "this";
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateDelete(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = new FullyQualifiedJavaType("java.lang.Integer");
        String methodName = "delete";
        String parameters = "this";
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateSelectAll(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewListInstance());
        FullyQualifiedJavaType baseRecordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getNewListInstance(); //baseRecordList
        returnType.addTypeArgument(baseRecordType);
        String methodName = "selectAll";
        String parameters = "";
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateCount(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "count";
        String parameters = "this";
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateSelectOne(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        String methodName = "selectOne";
        String parameters = "this";
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generateSelect(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewListInstance());
        FullyQualifiedJavaType baseRecordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getNewListInstance(); //baseRecordList
        returnType.addTypeArgument(baseRecordType);
        String methodName = "select";
        String parameters = "this";
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generaterReplace(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "replace";
        String parameters = "this";
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generaterReplaceSelective(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getIntInstance();
        String methodName = "replaceSelective";
        String parameters = "this";
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }

    private void generatePkValMethod(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getObjectInstance();
        String methodName = "pkVal";
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(returnType);
        method.setName(methodName); //$NON-NLS-1$
        if (introspectedTable.isJava5Targeted()) {
            method.addAnnotation("@Override"); //$NON-NLS-1$
        }

        // todo 需解决复合主键时存在的问题
        String bodyLine = String.format("return %s;", generateParameters(introspectedTable, topLevelClass));
        method.addBodyLine(bodyLine); //$NON-NLS-1$

        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3_DSQL) {
            context.getCommentGenerator().addGeneralMethodAnnotation(method, introspectedTable, topLevelClass.getImportedTypes());
        } else {
            context.getCommentGenerator().addGeneralMethodComment(method, introspectedTable);
        }
        topLevelClass.addMethod(method);
    }

    private void generateSelectPkVals(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getNewListInstance();
        returnType.addTypeArgument(FullyQualifiedJavaType.getObjectInstance());
        String methodName = "selectPkVals";
        String parameters = "this";
        Method method = generateActiveRecordMethod(topLevelClass, introspectedTable, returnType, methodName, parameters);
        topLevelClass.addMethod(method);
    }
}