/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account;

import com.xforceplus.bill.core.util.SystemUtil;
import com.xforceplus.xplat.aws.spring.annotation.EnableAwsClient;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.ConfigurableEnvironment;

@SpringBootApplication
@MapperScan(value={"com.xforceplus.bill.account.dao"})
@EnableAwsClient(packages="com.xforceplus.bill.account.sqs")
@EnableFeignClients(basePackages={"com.xforceplus"})
@ComponentScan(value={"com.xforceplus"})
public class AccountApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountApplication.class);

    public static void main(String[] args) {
        ConfigurableApplicationContext application = SpringApplication.run(AccountApplication.class, (String[])args);
        ConfigurableEnvironment env = application.getEnvironment();
        String ip = SystemUtil.getIp4Address().getHostAddress();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        if (StringUtils.isEmpty((CharSequence)path)) {
            path = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n----------------------------------------------------------\n\t").append("Application is running! Access URLs:\n\t").append("Local:      http://localhost:" + port + path + "/\n\t").append("            http://" + ip + ":" + port + path + "/\n\t").append("swagger-ui: http://localhost:" + port + path + "/swagger-ui.html\n\t").append("            http://" + ip + ":" + port + path + "/swagger-ui.html\n").append("----------------------------------------------------------");
        String info = sb.toString();
        LOGGER.info(info);
    }
}

