/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.config;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
public class AopLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(AopLoggingAspect.class);
    private static final String CONTROLLER_PACKAGE = "within(com.xforceplus.bill.account.controller..*)";

    @Around(value="within(com.xforceplus.bill.account.controller..*)")
    public Object logController(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            this.beforeRun(joinPoint);
            Object result = joinPoint.proceed();
            this.afterRun(joinPoint, result);
            return result;
        }
        catch (IllegalArgumentException e) {
            log.error("Illegal argument[s]: {} in {}.{}()", new Object[]{Arrays.toString(joinPoint.getArgs()), joinPoint.getSignature().getDeclaringType().getSimpleName(), joinPoint.getSignature().getName()});
            throw e;
        }
    }

    public void beforeRun(ProceedingJoinPoint joinPoint) {
        if (log.isInfoEnabled()) {
            String[] paramNames = ((MethodSignature)joinPoint.getSignature()).getParameterNames();
            Object[] arguments = joinPoint.getArgs();
            HashMap<String, Object> paramMap = new HashMap<String, Object>(arguments.length);
            for (int i = 0; i < arguments.length; ++i) {
                if (!this.isValidArgument(arguments[i])) continue;
                paramMap.put(paramNames[i], arguments[i]);
            }
            log.info("Request: {}.{}(), argument = {}", new Object[]{joinPoint.getSignature().getDeclaringType().getSimpleName(), joinPoint.getSignature().getName(), JSON.toJSONString(paramMap)});
        }
    }

    private void afterRun(ProceedingJoinPoint joinPoint, Object result) {
        if (log.isInfoEnabled()) {
            log.info("Response: {}.{}() with result = {}", new Object[]{joinPoint.getSignature().getDeclaringType().getSimpleName(), joinPoint.getSignature().getName(), JSON.toJSONString((Object)result)});
        }
    }

    private boolean isValidArgument(Object argument) {
        return !(argument instanceof ServletRequest) && !(argument instanceof ServletResponse);
    }
}

