/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.config;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="executor")
public class ExecutorConfig {
    private String workerName = "executor";
    private int maxWorkerSize = Runtime.getRuntime().availableProcessors();
    private int maxTaskSize = 1000;

    public void setMaxWorkerSize(int maxWorkerSize) {
        this.maxWorkerSize = maxWorkerSize;
    }

    public void setMaxTaskSize(int maxTaskSize) {
        this.maxTaskSize = maxTaskSize;
    }

    @Bean(value={"accountExecutor"})
    public ExecutorService executor() {
        int cpuCore = Runtime.getRuntime().availableProcessors();
        int core = 0;
        int max = 0;
        if (this.maxWorkerSize <= cpuCore) {
            core = cpuCore;
            max = cpuCore;
        } else {
            core = cpuCore;
            max = this.maxWorkerSize;
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(core, max, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.maxTaskSize), (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */, new ThreadPoolExecutor.CallerRunsPolicy());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> executor.shutdown()));
        return executor;
    }

    static /* synthetic */ String access$000(ExecutorConfig x0) {
        return x0.workerName;
    }
}

