/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Profile(value={"!prod"})
@EnableSwagger2
@Configuration
public class SwaggerConfig {
    public static final String XFORCE_SAAS_TOKEN = "xforce-saas-token";

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts()).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)"com.xforceplus.bill.account.controller")).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("\u8ba1\u8d39\u4e2d\u5fc3-\u8d26\u6237 API \u63a5\u53e3\u6587\u6863").description("\u6b22\u8fce \u8d26\u6237API \u6587\u6863!").version("1.0").build();
    }

    private List<SecurityContext> securityContexts() {
        SecurityContext build = SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.any()).build();
        ArrayList<SecurityContext> arrayList = new ArrayList<SecurityContext>();
        arrayList.add(build);
        return arrayList;
    }

    private List<ApiKey> securitySchemes() {
        ApiKey apiKey = new ApiKey(XFORCE_SAAS_TOKEN, XFORCE_SAAS_TOKEN, "header");
        ArrayList<ApiKey> apiKeys = new ArrayList<ApiKey>();
        apiKeys.add(apiKey);
        return apiKeys;
    }

    List<SecurityReference> defaultAuth() {
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{new AuthorizationScope("v2", "accessEverything")};
        SecurityReference securityReference = new SecurityReference(XFORCE_SAAS_TOKEN, authorizationScopes);
        ArrayList<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
        securityReferences.add(securityReference);
        return securityReferences;
    }
}

