/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.xforceplus.bill.account.api.dto.AdjustmentDTO;
import com.xforceplus.bill.account.api.dto.AuditDTO;
import com.xforceplus.bill.account.api.feign.AccountChangeApi;
import com.xforceplus.bill.account.api.vo.AccountChangeApplyVo;
import com.xforceplus.bill.account.api.vo.PageVo;
import com.xforceplus.bill.account.controller.search.AccountChangeApplySearch;
import com.xforceplus.bill.account.converter.AccountChangeApplyConverter;
import com.xforceplus.bill.account.entity.Account;
import com.xforceplus.bill.account.entity.AccountChangeApply;
import com.xforceplus.bill.account.exception.ParameterException;
import com.xforceplus.bill.account.service.IAccountChangeApplyService;
import com.xforceplus.bill.account.service.IAccountService;
import com.xforceplus.bill.account.utils.PageUtil;
import com.xforceplus.bill.core.util.BeanUtil;
import com.xforceplus.bill.core.util.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Date;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d26\u6237\u8c03\u8d26"})
@RestController
public class AccountChangeApplyController
implements AccountChangeApi {
    private final IAccountChangeApplyService accountChangeApplyService;
    private final IAccountService accountService;
    private final AccountChangeApplyConverter applyConverter;

    public R<PageVo<AccountChangeApplyVo>> adjustmentList(@ApiParam(value="\u79df\u6237id") @PathVariable(value="tenantId") Long tenantId, @RequestParam(required=false) Long accountId, @RequestParam(required=false) String accountName, @RequestParam(required=false) Date startDate, @RequestParam(required=false) Date endDate, @NotNull Integer pageNo, @NotNull Integer pageSize) {
        AccountChangeApplySearch accountChangeApplySearch = new AccountChangeApplySearch();
        accountChangeApplySearch.setAccountId(accountId);
        accountChangeApplySearch.setAccountName(accountName);
        accountChangeApplySearch.setStartDate(startDate);
        accountChangeApplySearch.setEndDate(endDate);
        IPage pageData = this.accountChangeApplyService.findListByPage(accountChangeApplySearch, pageNo, pageSize);
        return R.ok((Object)PageUtil.convertPageVo((IPage)pageData, arg_0 -> ((AccountChangeApplyConverter)this.applyConverter).toVO(arg_0)));
    }

    public R<AccountChangeApplyVo> adjustment(@ApiParam(value="\u79df\u6237id") @PathVariable(value="tenantId") Long tenantId, @Valid AdjustmentDTO adjustmentDTO) {
        Account account = (Account)this.accountService.getById((Serializable)adjustmentDTO.getAccountId());
        if (account == null) {
            throw new ParameterException("\u8d26\u6237ID:" + adjustmentDTO.getAccountId() + "\u5bf9\u5e94\u7684\u5e10\u6237\u4e0d\u5b58\u5728");
        }
        adjustmentDTO.setAccountName(account.getAccountName());
        AccountChangeApply apply = this.accountChangeApplyService.createApply(adjustmentDTO);
        return R.ok((Object)BeanUtil.convert((Object)apply, AccountChangeApplyVo.class));
    }

    public R<AccountChangeApplyVo> approveAccount(@ApiParam(value="\u79df\u6237id") @PathVariable(value="tenantId") Long tenantId, @Valid AuditDTO auditDTO) {
        AccountChangeApply apply = this.accountChangeApplyService.approveChange(tenantId, auditDTO);
        return R.ok((Object)BeanUtil.convert((Object)apply, AccountChangeApplyVo.class));
    }

    public AccountChangeApplyController(IAccountChangeApplyService accountChangeApplyService, IAccountService accountService, AccountChangeApplyConverter applyConverter) {
        this.accountChangeApplyService = accountChangeApplyService;
        this.accountService = accountService;
        this.applyConverter = applyConverter;
    }
}

