/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.xforceplus.bill.account.api.dto.ConsumeRuleDTO;
import com.xforceplus.bill.account.api.feign.AccountConfigApi;
import com.xforceplus.bill.account.api.vo.AccountConsumeRuleVo;
import com.xforceplus.bill.account.api.vo.PageVo;
import com.xforceplus.bill.account.controller.search.AccountConfigSearch;
import com.xforceplus.bill.account.converter.AccountConfigConverter;
import com.xforceplus.bill.account.entity.Account;
import com.xforceplus.bill.account.entity.AccountConfig;
import com.xforceplus.bill.account.exception.ParameterException;
import com.xforceplus.bill.account.service.IAccountConfigService;
import com.xforceplus.bill.account.service.IAccountService;
import com.xforceplus.bill.account.utils.PageUtil;
import com.xforceplus.bill.account.utils.UserUtil;
import com.xforceplus.bill.core.util.BeanUtil;
import com.xforceplus.bill.core.util.R;
import io.geewit.core.utils.reflection.BeanUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Date;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d26\u6237\u914d\u7f6e"})
@RestController
public class AccountConfigController
implements AccountConfigApi {
    private final IAccountConfigService accountConfigService;
    private final IAccountService accountService;
    private final AccountConfigConverter accountConfigConverter;

    public R<AccountConsumeRuleVo> consumeRule(Long tenantId, @Valid ConsumeRuleDTO consumeRuleDTO) {
        Account account = (Account)this.accountService.getById((Serializable)consumeRuleDTO.getAccountId());
        if (account == null) {
            throw new ParameterException("\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)consumeRuleDTO.getConsumeOrder())) {
            throw new ParameterException("\u6d88\u8d39\u987a\u5e8f\u7684\u5185\u5bb9\u586b\u5199\u4e0d\u7b26\u5408\u8981\u6c42\u3002");
        }
        AccountConfig accountConfig = new AccountConfig();
        BeanUtils.copyProperties((Object)consumeRuleDTO, (Object)accountConfig);
        accountConfig.setTenantId(tenantId);
        accountConfig.setCreateBy(UserUtil.getUserInfo().getUsername());
        accountConfig.setCreateTime(new Date());
        accountConfig.setUpdateBy(UserUtil.getUserInfo().getUsername());
        accountConfig.setUpdateTime(new Date());
        this.accountConfigService.add(accountConfig);
        return R.ok((Object)BeanUtil.convert((Object)accountConfig, AccountConsumeRuleVo.class));
    }

    public R<PageVo<AccountConsumeRuleVo>> findConsumeRule(Long tenantId, @RequestParam(required=false) Long accountId, @RequestParam(required=false) Date startDate, @RequestParam(required=false) Date endDate, @NotNull Integer pageNo, @NotNull Integer pageSize) {
        AccountConfigSearch accountConfigSearch = new AccountConfigSearch();
        accountConfigSearch.setAccountId(accountId);
        accountConfigSearch.setStartDate(startDate);
        accountConfigSearch.setEndDate(endDate);
        IPage pageData = this.accountConfigService.findListByPage(accountConfigSearch, pageNo, pageSize);
        return R.ok((Object)PageUtil.convertPageVo((IPage)pageData, arg_0 -> ((AccountConfigConverter)this.accountConfigConverter).toConsumeRuleVO(arg_0)));
    }

    public R<AccountConsumeRuleVo> updateConsumeRule(Long tenantId, @Valid ConsumeRuleDTO consumeRuleDTO) {
        AccountConfig accountConfig = this.accountConfigService.findById(consumeRuleDTO.getId());
        if (accountConfig == null) {
            throw new ParameterException("\u5e10\u6237\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)consumeRuleDTO.getConsumeOrder())) {
            throw new ParameterException("\u6d88\u8d39\u987a\u5e8f\u7684\u5185\u5bb9\u586b\u5199\u4e0d\u7b26\u5408\u8981\u6c42\u3002");
        }
        accountConfig.setConsumeOrder(consumeRuleDTO.getConsumeOrder());
        accountConfig.setUpdateBy(UserUtil.getUserInfo().getUsername());
        accountConfig.setUpdateTime(new Date());
        this.accountConfigService.updateData(accountConfig);
        return R.ok((Object)BeanUtil.convert((Object)accountConfig, AccountConsumeRuleVo.class));
    }

    public R<AccountConsumeRuleVo> deleteConsumeRule(Long tenantId, @ApiParam(value="\u914d\u7f6eid") @RequestParam Long id) {
        AccountConfig accountConfig = this.accountConfigService.findById(id);
        if (accountConfig == null) {
            throw new ParameterException("\u5e10\u6237\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        this.accountConfigService.delete(id);
        return R.ok();
    }

    public AccountConfigController(IAccountConfigService accountConfigService, IAccountService accountService, AccountConfigConverter accountConfigConverter) {
        this.accountConfigService = accountConfigService;
        this.accountService = accountService;
        this.accountConfigConverter = accountConfigConverter;
    }
}

