/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.controller;

import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.xforceplus.bill.account.api.dto.ConsumeDTO;
import com.xforceplus.bill.account.api.dto.CreateAccountDTO;
import com.xforceplus.bill.account.api.dto.CreditDTO;
import com.xforceplus.bill.account.api.dto.FreezeDTO;
import com.xforceplus.bill.account.api.dto.RechargeDTO;
import com.xforceplus.bill.account.api.dto.RefundDTO;
import com.xforceplus.bill.account.api.dto.RollbackDTO;
import com.xforceplus.bill.account.api.feign.AccountApi;
import com.xforceplus.bill.account.api.vo.AccountTransactionQueryVo;
import com.xforceplus.bill.account.api.vo.AccountVo;
import com.xforceplus.bill.account.api.vo.PageVo;
import com.xforceplus.bill.account.controller.search.AccountSearch;
import com.xforceplus.bill.account.controller.search.AccountTransactionSearch;
import com.xforceplus.bill.account.converter.AccountConverter;
import com.xforceplus.bill.account.converter.AccountTransactionConverter;
import com.xforceplus.bill.account.entity.Account;
import com.xforceplus.bill.account.exception.ParameterException;
import com.xforceplus.bill.account.service.IAccountService;
import com.xforceplus.bill.account.service.IAccountTransactionService;
import com.xforceplus.bill.account.utils.AppUtil;
import com.xforceplus.bill.account.utils.HttpUtil;
import com.xforceplus.bill.account.utils.PageUtil;
import com.xforceplus.bill.core.util.BeanUtil;
import com.xforceplus.bill.core.util.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d26\u6237\u7ba1\u7406"})
@RestController
public class AccountController
implements AccountApi {
    private final IAccountService accountService;
    private final IAccountTransactionService accountTransactionService;
    private final AccountConverter accountConverter;
    private final AccountTransactionConverter accountTransactionConverter;
    @Value(value="${xbill.center.url}")
    private String xBillCenterUrl;

    public R<AccountVo> createAccount(@ApiParam(value="\u79df\u6237id") @PathVariable(value="tenantId") Long tenantId, @RequestBody @Valid CreateAccountDTO createAccountDTO) {
        createAccountDTO.setTenantId(tenantId);
        return R.ok((Object)BeanUtil.convert((Object)this.accountService.createAccount(createAccountDTO), AccountVo.class));
    }

    public R<PageVo<AccountVo>> queryAccount(Long tenantId, @NotNull Long appId, @RequestParam(name="appName", required=false) Long appName, @ApiParam(value="\u8d26\u6237\u540d\u79f0") @RequestParam(name="accountName", required=false) String accountName, @ApiParam(value="\u8d26\u6237ID") @RequestParam(name="accountId", required=false) Long accountId, @ApiParam(value="\u8d26\u6237\u53f7") @RequestParam(name="accountNo", required=false) String accountNo, @NotNull Integer pageNo, @NotNull Integer pageSize) {
        AccountSearch condition = new AccountSearch();
        condition.setAccountName(accountName);
        condition.setAccountNo(accountNo);
        condition.setId(accountId);
        IPage pageData = this.accountService.findListByPage(condition, pageNo, pageSize);
        return R.ok((Object)PageUtil.convertPageVo((IPage)pageData, arg_0 -> ((AccountConverter)this.accountConverter).toVO(arg_0)));
    }

    public R<List<AccountVo>> queryAccount(@ApiParam(value="\u79df\u6237id") @PathVariable(value="tenantId") Long tenantId, @ApiParam(value="\u8d26\u6237\u540d\u79f0") @RequestParam(name="accountName", required=false) String accountName, @ApiParam(value="\u8d26\u6237\u53f7") @RequestParam(name="accountNo", required=false) String accountNo) {
        AccountSearch search = new AccountSearch();
        search.setTenantId(tenantId);
        search.setAccountName(accountName);
        search.setAccountNo(accountNo);
        List list = this.accountService.list(search);
        return R.ok((Object)BeanUtil.convert((List)list, AccountVo.class));
    }

    public R<PageVo<AccountTransactionQueryVo>> queryAccountTransaction(Long tenantId, Long appId, Long accountId, Date startDate, Date endDate, Integer pageNo, Integer pageSize) {
        AccountTransactionSearch condition = new AccountTransactionSearch();
        condition.setStartDate(startDate);
        condition.setEndDate(endDate);
        condition.setAccountId(accountId);
        IPage pageData = this.accountTransactionService.findListByPage(condition, pageNo, pageSize);
        return R.ok((Object)PageUtil.convertPageVo((IPage)pageData, (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
    }

    public R<AccountVo> recharge(@ApiParam(value="\u79df\u6237id") @PathVariable(value="tenantId") Long tenantId, @RequestBody @Valid RechargeDTO rechargeDTO) {
        if (!AppUtil.isMoneyFormat((BigDecimal)rechargeDTO.getRechargeAmount())) {
            throw new IllegalArgumentException("\u5145\u503c\u91d1\u989d\u4e0d\u5408\u6cd5");
        }
        if (rechargeDTO.getAwardAmount() != null) {
            if (!AppUtil.isMoneyFormat((BigDecimal)rechargeDTO.getAwardAmount())) {
                throw new IllegalArgumentException("\u8d60\u9001\u91d1\u989d\u4e0d\u5408\u6cd5");
            }
            if (StringUtils.isBlank((CharSequence)rechargeDTO.getAwardBusinessNo())) {
                throw new IllegalArgumentException("\u8d60\u9001\u4e1a\u52a1\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        Account accountEntity = this.accountService.recharge(rechargeDTO);
        return R.ok((Object)BeanUtil.convert((Object)accountEntity, AccountVo.class));
    }

    public R rechargeCreateOrder(Long tenantId, Long accountId, BigDecimal rechargeAmt) {
        Account account = (Account)this.accountService.getById((Serializable)accountId);
        if (account == null) {
            throw new ParameterException("\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        if (!AppUtil.isMoneyFormat((BigDecimal)rechargeAmt)) {
            throw new IllegalArgumentException("\u5145\u503c\u91d1\u989d\u4e0d\u5408\u6cd5");
        }
        Map map = HttpUtil.createRechargeOrder((String)this.xBillCenterUrl, (Account)account, (BigDecimal)rechargeAmt);
        return R.ok((Object)((Map)map.get("result")));
    }

    public R<AccountVo> consume(@ApiParam(value="\u79df\u6237id") @PathVariable(value="tenantId") Long tenantId, @RequestBody @Valid ConsumeDTO consumeDTO) {
        if (!AppUtil.isMoneyFormat((BigDecimal)consumeDTO.getConsumeAmount())) {
            throw new IllegalArgumentException("\u6d88\u8d39\u91d1\u989d\u975e\u6cd5");
        }
        Account accountEntity = this.accountService.consume(consumeDTO);
        return R.ok((Object)BeanUtil.convert((Object)accountEntity, AccountVo.class));
    }

    public R<AccountVo> rollback(@ApiParam(value="\u79df\u6237id") @PathVariable(value="tenantId") Long tenantId, @RequestBody @Valid RollbackDTO rollbackDTO) {
        Account accountEntity = this.accountService.rollback(rollbackDTO);
        return R.ok((Object)BeanUtil.convert((Object)accountEntity, AccountVo.class));
    }

    public R<AccountVo> refund(@ApiParam(value="\u79df\u6237id") @PathVariable(value="tenantId") Long tenantId, @RequestBody @Valid RefundDTO refundDTO) {
        Account accountEntity = this.accountService.refund(refundDTO);
        return R.ok((Object)BeanUtil.convert((Object)accountEntity, AccountVo.class));
    }

    public R<AccountVo> frozen(Long tenantId, @Valid FreezeDTO freezeDTO) {
        Account accountEntity = this.accountService.frozenAmount(tenantId, freezeDTO);
        return R.ok((Object)BeanUtil.convert((Object)accountEntity, AccountVo.class));
    }

    public R<AccountVo> creditLimit(Long tenantId, @Valid CreditDTO creditDTO) {
        Account accountEntity = this.accountService.creditLimit(tenantId, creditDTO);
        return R.ok((Object)BeanUtil.convert((Object)accountEntity, AccountVo.class));
    }

    public R<AccountVo> changeStatus(Long tenantId, Long accountId, Integer status) {
        Account accountEntity = this.accountService.changeStatus(tenantId, accountId, status);
        return R.ok((Object)BeanUtil.convert((Object)accountEntity, AccountVo.class));
    }

    public AccountController(IAccountService accountService, IAccountTransactionService accountTransactionService, AccountConverter accountConverter, AccountTransactionConverter accountTransactionConverter) {
        this.accountService = accountService;
        this.accountTransactionService = accountTransactionService;
        this.accountConverter = accountConverter;
        this.accountTransactionConverter = accountTransactionConverter;
    }
}

