/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.bill.account.api.dto.AccountShareRelDTO;
import com.xforceplus.bill.account.api.feign.AccountShareRelApi;
import com.xforceplus.bill.account.entity.Account;
import com.xforceplus.bill.account.entity.AccountShareRel;
import com.xforceplus.bill.account.exception.ParameterException;
import com.xforceplus.bill.account.service.IAccountService;
import com.xforceplus.bill.account.service.IAccountShareRelService;
import com.xforceplus.bill.core.util.IdUtil;
import com.xforceplus.bill.core.util.R;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d26\u6237\u5171\u4eab\u5173\u8054"})
@RestController
public class AccountShareRelController
implements AccountShareRelApi {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final IAccountService accountService;
    private final IAccountShareRelService accountShareRelService;

    public R batchAddRel(Long tenantId, @Valid @RequestBody AccountShareRelDTO accountShareRelDTO) {
        int cnt = this.accountService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Account::getId, (Object)accountShareRelDTO.getAccountId())).eq(Account::getCompanyId, (Object)accountShareRelDTO.getAccountCompanyId()));
        if (cnt == 0) {
            throw new ParameterException("accountId\u6216companyId\u975e\u6cd5!");
        }
        ArrayList list = new ArrayList();
        accountShareRelDTO.getSharedCompanyIds().forEach(id -> {
            AccountShareRel rel = new AccountShareRel();
            rel.setAccountId(accountShareRelDTO.getAccountId());
            rel.setAccountCompanyId(accountShareRelDTO.getAccountCompanyId());
            rel.setSharedCompanyId(id);
            rel.setId(IdUtil.nextId());
            list.add(rel);
        });
        this.accountShareRelService.saveBatch(list);
        return R.ok();
    }

    public AccountShareRelController(IAccountService accountService, IAccountShareRelService accountShareRelService) {
        this.accountService = accountService;
        this.accountShareRelService = accountShareRelService;
    }
}

