/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.controller;

import com.alibaba.excel.EasyExcel;
import com.xforceplus.bill.account.api.feign.AccountTransactionApi;
import com.xforceplus.bill.account.bo.AccountTransactionData;
import com.xforceplus.bill.account.service.IAccountTransactionService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d26\u6237\u4ea4\u6613\u6d41\u6c34"})
@RestController
public class AccountTransactionController
implements AccountTransactionApi {
    private final IAccountTransactionService accountTransactionService;

    public void export(Long tenantId, @NotNull Long appId, Long accountId, Date startDate, Date endDate, HttpServletResponse response) {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        try {
            String fileName = URLEncoder.encode(new DateTime().toString("yyyy-MM-dd:HH:mm:ss") + "\u4ea4\u6613\u6d41\u6c34", "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            List datas = this.accountTransactionService.queryTransaction(accountId, startDate, endDate);
            EasyExcel.write((OutputStream)response.getOutputStream(), AccountTransactionData.class).sheet("\u4ea4\u6613\u6d41\u6c34").doWrite(datas);
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25!", e);
        }
    }

    public AccountTransactionController(IAccountTransactionService accountTransactionService) {
        this.accountTransactionService = accountTransactionService;
    }
}

