/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.controller;

import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.xforceplus.bill.account.api.dto.BusinessConfigDTO;
import com.xforceplus.bill.account.api.dto.BusinessTypeDTO;
import com.xforceplus.bill.account.api.feign.BusinessApi;
import com.xforceplus.bill.account.api.vo.BusinessConfigVo;
import com.xforceplus.bill.account.api.vo.BusinessTypeVo;
import com.xforceplus.bill.account.api.vo.PageVo;
import com.xforceplus.bill.account.controller.search.BusinessConfigSearch;
import com.xforceplus.bill.account.converter.BusinessConfigConverter;
import com.xforceplus.bill.account.entity.BusinessConfig;
import com.xforceplus.bill.account.entity.BusinessType;
import com.xforceplus.bill.account.exception.ParameterException;
import com.xforceplus.bill.account.service.IBusinessConfigService;
import com.xforceplus.bill.account.service.IBusinessTypeService;
import com.xforceplus.bill.account.utils.PageUtil;
import com.xforceplus.bill.account.utils.UserUtil;
import com.xforceplus.bill.core.util.R;
import io.geewit.core.utils.reflection.BeanUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e1a\u52a1\u529f\u80fd\u914d\u7f6e"})
@RestController
public class BusinessController
implements BusinessApi {
    private final IBusinessTypeService businessTypeService;
    private final IBusinessConfigService businessConfigService;
    private final BusinessConfigConverter businessConfigConverter;

    public R<String> addBusinessType(@ApiParam(value="\u79df\u6237id") @PathVariable(value="tenantId") Long tenantId, BusinessTypeDTO businessTypeDTO) {
        BusinessType type = new BusinessType();
        BeanUtils.copyProperties((Object)businessTypeDTO, (Object)type);
        this.businessTypeService.add(type);
        return R.ok();
    }

    public R<List<BusinessTypeVo>> queryBusinessType(@ApiParam(value="\u79df\u6237id") @PathVariable(value="tenantId") Long tenantId) {
        List data = this.businessTypeService.list().stream().map(businessType -> {
            BusinessTypeVo businessTypeVo = new BusinessTypeVo();
            BeanUtils.copyProperties((Object)businessType, (Object)businessTypeVo);
            return businessTypeVo;
        }).collect(Collectors.toList());
        return R.ok(data);
    }

    public R<Boolean> addBusinessConfig(Long tenantId, BusinessConfigDTO businessConfigDTO) {
        if (businessConfigDTO.getId() == null) {
            ArrayList<BusinessConfig> businessConfigs = new ArrayList<BusinessConfig>();
            for (BusinessConfigDTO.BusinessType businessType : businessConfigDTO.getBusinessType()) {
                BusinessConfig businessConfig = new BusinessConfig();
                BeanUtils.copyProperties((Object)businessConfigDTO, (Object)businessConfig);
                businessConfig.setBusinessCode(businessType.getBusinessCode());
                businessConfig.setBusinessId(businessType.getBusinessId());
                businessConfig.setCreateUser(UserUtil.getUserInfo().getUserName());
                businessConfigs.add(businessConfig);
            }
            this.businessConfigService.save(businessConfigs);
        } else {
            BusinessConfig businessConfig = new BusinessConfig();
            businessConfig.setAppId(businessConfigDTO.getAppId());
            businessConfig.setAppName(businessConfigDTO.getAppName());
            businessConfig.setId(businessConfigDTO.getId());
            businessConfig.setUpdateTime(new Date());
            businessConfig.setBusinessId(((BusinessConfigDTO.BusinessType)businessConfigDTO.getBusinessType().get(0)).getBusinessId());
            businessConfig.setBusinessCode(((BusinessConfigDTO.BusinessType)businessConfigDTO.getBusinessType().get(0)).getBusinessCode());
            this.businessConfigService.update(businessConfig);
        }
        return R.ok();
    }

    public R<PageVo<BusinessConfigVo>> queryBusinessConfig(@ApiParam(value="\u79df\u6237id") @PathVariable(value="tenantId") Long tenantId, String appId, String appName, @NotNull Integer pageNo, @NotNull Integer pageSize) {
        BusinessConfigSearch businessConfigSearch = new BusinessConfigSearch();
        businessConfigSearch.setAppId(appId);
        businessConfigSearch.setAppName(appName);
        IPage pageData = this.businessConfigService.findListByPage(pageNo, pageSize, businessConfigSearch);
        return R.ok((Object)PageUtil.convertPageVo((IPage)pageData, (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
    }

    public R<Boolean> deleteBusinessConfig(@ApiParam(value="\u79df\u6237id") @PathVariable(value="tenantId") Long tenantId, Long id) {
        int count = this.businessConfigService.delete(id);
        if (count == 0) {
            throw new ParameterException("\u4e0d\u5b58\u5728\u8be5\u914d\u7f6e!");
        }
        return R.ok();
    }

    public BusinessController(IBusinessTypeService businessTypeService, IBusinessConfigService businessConfigService, BusinessConfigConverter businessConfigConverter) {
        this.businessTypeService = businessTypeService;
        this.businessConfigService = businessConfigService;
        this.businessConfigConverter = businessConfigConverter;
    }
}

