/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.exception;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.xforceplus.bill.account.api.enums.ResponseCodeEnum;
import com.xforceplus.bill.account.api.vo.DefaultResponse;
import com.xforceplus.bill.account.bo.ApiError;
import com.xforceplus.bill.account.exception.ParameterException;
import com.xforceplus.bill.core.exception.GlobalExceptionHandlerResolver;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class AccountControllerAdvice
extends GlobalExceptionHandlerResolver {
    @ResponseBody
    @ExceptionHandler(value={ParameterException.class})
    protected ResponseEntity<Object> handlerParameterException(ParameterException ex) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST);
        apiError.setMessage(ex.getMessage());
        apiError.setDebugMessage(ex.getMessage());
        apiError.setCode(ResponseCodeEnum.PARAM_ERROR.getCode());
        return this.buildResponseEntity(apiError);
    }

    @ResponseBody
    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<Object> handlerIllegalArgumentException(IllegalArgumentException ex) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST);
        apiError.setMessage(ex.getMessage());
        apiError.setDebugMessage(ex.getMessage());
        apiError.setCode(ResponseCodeEnum.PARAM_ERROR.getCode());
        return this.buildResponseEntity(apiError);
    }

    @ResponseBody
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    protected ResponseEntity<Object> handlerInvalidFormatException(HttpMessageNotReadableException ex) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST);
        apiError.setMessage(ex.getMessage());
        apiError.setDebugMessage(ex.getMessage());
        apiError.setCode(ResponseCodeEnum.PARAM_ERROR.getCode());
        return this.buildResponseEntity(apiError);
    }

    private ResponseEntity<Object> buildResponseEntity(ApiError apiError) {
        DefaultResponse defaultResponse = new DefaultResponse();
        defaultResponse.setCode(apiError.getCode());
        defaultResponse.setMessage(apiError.getMessage());
        defaultResponse.setResult((Object)apiError.getSubErrors());
        return new ResponseEntity((Object)defaultResponse, apiError.getStatus());
    }

    @ResponseBody
    @ExceptionHandler(value={InvalidFormatException.class})
    protected ResponseEntity<Object> handlerFormatException(InvalidFormatException ex) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST);
        apiError.setMessage(ex.getMessage());
        apiError.setDebugMessage(ex.getMessage());
        apiError.setCode(ResponseCodeEnum.PARAM_ERROR.getCode());
        return this.buildResponseEntity(apiError);
    }
}

