/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.interceptor;

import com.xforceplus.bill.common.data.context.UserIdContextHolder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class UserIdContextInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(UserIdContextInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        IAuthorizedUser user = UserInfoHolder.get();
        if (null != user) {
            UserIdContextHolder.set((Long)user.getId());
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
        UserIdContextHolder.clear();
    }
}

