/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.bill.account.api.dto.AdjustmentDTO;
import com.xforceplus.bill.account.api.dto.AuditDTO;
import com.xforceplus.bill.account.api.enums.AccountChangeStatusEnum;
import com.xforceplus.bill.account.api.enums.AccountTypeEnum;
import com.xforceplus.bill.account.controller.search.AccountChangeApplySearch;
import com.xforceplus.bill.account.dao.AccountChangeApplyMapper;
import com.xforceplus.bill.account.entity.AccountChangeApply;
import com.xforceplus.bill.account.entity.AccountTransaction;
import com.xforceplus.bill.account.exception.ParameterException;
import com.xforceplus.bill.account.service.IAccountChangeApplyService;
import com.xforceplus.bill.account.service.IAccountService;
import com.xforceplus.bill.account.utils.UserUtil;
import com.xforceplus.bill.core.util.IdUtil;
import java.io.Serializable;
import java.util.Date;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AccountChangeApplyServiceImpl
extends ServiceImpl<AccountChangeApplyMapper, AccountChangeApply>
implements IAccountChangeApplyService {
    private final AccountChangeApplyMapper accountChangeApplyMapper;
    private final IAccountService accountService;

    public IPage<AccountChangeApply> findListByPage(Integer page, Integer pageCount) {
        Page wherePage = new Page((long)page.intValue(), (long)pageCount.intValue());
        AccountChangeApply where = new AccountChangeApply();
        return ((AccountChangeApplyMapper)this.baseMapper).selectPage((IPage)wherePage, (Wrapper)Wrappers.query((Object)where));
    }

    public int add(AccountChangeApply accountChangeApply) {
        accountChangeApply.setId(IdUtil.nextId());
        return ((AccountChangeApplyMapper)this.baseMapper).insert((Object)accountChangeApply);
    }

    public int delete(Long id) {
        return ((AccountChangeApplyMapper)this.baseMapper).deleteById((Serializable)id);
    }

    public int updateData(AccountChangeApply accountChangeApply) {
        return ((AccountChangeApplyMapper)this.baseMapper).updateById((Object)accountChangeApply);
    }

    public AccountChangeApply findById(Long id) {
        return (AccountChangeApply)((AccountChangeApplyMapper)this.baseMapper).selectById((Serializable)id);
    }

    public AccountChangeApply createApply(AdjustmentDTO adjustmentDTO) {
        AccountChangeApply applyEntity = new AccountChangeApply();
        applyEntity.setAccountId(adjustmentDTO.getAccountId());
        applyEntity.setAccountName(adjustmentDTO.getAccountName());
        applyEntity.setAmount(adjustmentDTO.getAdjustAmount());
        if (null == AccountTypeEnum.fromCode((String)adjustmentDTO.getAccountType())) {
            throw new ParameterException("\u8f93\u5165\u7684\u8d26\u6237\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42\u3002");
        }
        applyEntity.setAccountType(adjustmentDTO.getAccountType());
        applyEntity.setReason(adjustmentDTO.getRemark());
        applyEntity.setApplyBy(UserUtil.getUserInfo().getUsername());
        applyEntity.setApplyTime(new Date());
        applyEntity.setCreateBy(UserUtil.getUserInfo().getUsername());
        applyEntity.setCreateTime(new Date());
        applyEntity.setUpdateBy(UserUtil.getUserInfo().getUsername());
        applyEntity.setUpdateTime(new Date());
        applyEntity.setId(IdUtil.nextId());
        this.accountChangeApplyMapper.insert((Object)applyEntity);
        return applyEntity;
    }

    public IPage<AccountChangeApply> findListByPage(AccountChangeApplySearch condition, Integer pageNo, Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        page = ((AccountChangeApplyMapper)this.baseMapper).selectPage((IPage)page, this.getQueryWrapper(condition));
        return page;
    }

    private Wrapper<AccountChangeApply> getQueryWrapper(AccountChangeApplySearch condition) {
        QueryWrapper wrapper = new QueryWrapper();
        if (null != condition.getAccountId()) {
            wrapper.eq((Object)"account_id", (Object)condition.getAccountId());
        }
        if (StringUtils.hasText((String)condition.getAccountName())) {
            wrapper.like((Object)"account_name", (Object)condition.getAccountName());
        }
        if (null != condition.getStartDate()) {
            wrapper.ge((Object)"create_time", (Object)condition.getStartDate());
        }
        if (null != condition.getEndDate()) {
            wrapper.le((Object)"create_time", (Object)condition.getEndDate());
        }
        wrapper.orderByDesc((Object)"id");
        return wrapper;
    }

    public AccountChangeApply approveChange(Long tenantId, AuditDTO auditDTO) {
        AccountChangeApply applyEntity = (AccountChangeApply)this.accountChangeApplyMapper.selectById((Serializable)auditDTO.getId());
        if (applyEntity == null) {
            throw new IllegalArgumentException("\u8c03\u8d26\u7533\u8bf7ID:" + auditDTO.getId() + "\u5bf9\u5e94\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (!applyEntity.getStatus().equals(AccountChangeStatusEnum.ACCOUNT_CHANGE_INIT.getCode())) {
            throw new IllegalArgumentException("\u8c03\u8d26\u7533\u8bf7ID:" + auditDTO.getId() + "\u5bf9\u5e94\u7684\u72b6\u6001\u4e0d\u662f\u5f85\u5ba1\u6838\u3002");
        }
        if (auditDTO.isAudit()) {
            AccountTransaction changeAccount = null;
            changeAccount = applyEntity.getAccountType().equalsIgnoreCase(AccountTypeEnum.RECHARGE_BALANCE.getCode()) ? this.accountService.adjustBalance(applyEntity.getAccountId(), applyEntity.getAmount(), null, applyEntity.getId() + "") : this.accountService.adjustBalance(applyEntity.getAccountId(), null, applyEntity.getAmount(), applyEntity.getId() + "");
            applyEntity.setTransactionNo(changeAccount.getTransactionNo());
            applyEntity.setStatus(AccountChangeStatusEnum.ACCOUNT_CHANGE_APPROVED.getCode());
        } else {
            applyEntity.setStatus(AccountChangeStatusEnum.ACCOUNT_CHANGE_UNAPPROVED.getCode());
        }
        applyEntity.setRemark(auditDTO.getRemark());
        applyEntity.setAuditBy(UserUtil.getUserInfo().getUsername());
        applyEntity.setAuditTime(new Date());
        this.accountChangeApplyMapper.updateById((Object)applyEntity);
        return applyEntity;
    }

    public AccountChangeApplyServiceImpl(AccountChangeApplyMapper accountChangeApplyMapper, IAccountService accountService) {
        this.accountChangeApplyMapper = accountChangeApplyMapper;
        this.accountService = accountService;
    }
}

