/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.bill.account.api.dto.ConsumeDTO;
import com.xforceplus.bill.account.api.dto.CreateAccountDTO;
import com.xforceplus.bill.account.api.dto.CreditDTO;
import com.xforceplus.bill.account.api.dto.FreezeDTO;
import com.xforceplus.bill.account.api.dto.RechargeDTO;
import com.xforceplus.bill.account.api.dto.RefundDTO;
import com.xforceplus.bill.account.api.dto.RollbackDTO;
import com.xforceplus.bill.account.api.enums.AccountStatusEnum;
import com.xforceplus.bill.account.api.enums.TransactionTypeEnum;
import com.xforceplus.bill.account.bo.BusinessConfigBO;
import com.xforceplus.bill.account.bo.UpdateBalanceBean;
import com.xforceplus.bill.account.controller.search.AccountSearch;
import com.xforceplus.bill.account.dao.AccountMapper;
import com.xforceplus.bill.account.dao.AccountTransactionMapper;
import com.xforceplus.bill.account.dao.BusinessConfigMapper;
import com.xforceplus.bill.account.entity.Account;
import com.xforceplus.bill.account.entity.AccountTransaction;
import com.xforceplus.bill.account.service.IAccountService;
import com.xforceplus.bill.account.service.impl.AccountServiceImpl;
import com.xforceplus.bill.account.utils.AppUtil;
import com.xforceplus.bill.account.utils.UserUtil;
import com.xforceplus.bill.core.util.IdUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class AccountServiceImpl
extends ServiceImpl<AccountMapper, Account>
implements IAccountService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountServiceImpl.class);
    @Autowired
    private final AccountMapper accountMapper;
    @Autowired
    private final AccountTransactionMapper accountTransactionMapper;
    @Autowired
    private final BusinessConfigMapper businessConfigMapper;

    public Account createAccount(CreateAccountDTO createAccountDTO) {
        Account account = new Account();
        account.setAccountNo(IdUtil.nextIdStr());
        account.setCompanyId(createAccountDTO.getCompanyId());
        account.setTenantId(createAccountDTO.getTenantId());
        account.setAccountName(createAccountDTO.getAccountName());
        account.setAccountType(Integer.valueOf(1));
        account.setBalance(BigDecimal.ZERO);
        account.setRechargeBalance(BigDecimal.ZERO);
        account.setAwardBalance(BigDecimal.ZERO);
        account.setFrozenAmount(BigDecimal.ZERO);
        account.setCreditLimit(AppUtil.DEFAULT_CREDIT_LIMIT);
        account.setStatus(Integer.valueOf(1));
        account.setCreateBy(UserUtil.getUserInfo().getUsername());
        account.setCreateTime(new Date());
        account.setUpdateBy(UserUtil.getUserInfo().getUsername());
        account.setUpdateTime(new Date());
        account.setId(IdUtil.nextId());
        this.accountMapper.insert((Object)account);
        this.accountTransactionMapper.insert((Object)this.buildEmptyTransaction(account, TransactionTypeEnum.OPEN, account.getAccountNo(), createAccountDTO.getAppId()));
        return account;
    }

    public Account recharge(RechargeDTO rechargeDTO) {
        Account account = this.accountMapper.selectByIdWithLock(rechargeDTO.getAccountId());
        if (account == null) {
            throw new IllegalArgumentException("\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        this.checkPrivilege(account);
        UpdateBalanceBean updateBalanceBean = UpdateBalanceBean.builder().useRechargeAmount(rechargeDTO.getRechargeAmount()).transactionType(TransactionTypeEnum.RECHARGE).businessNo(rechargeDTO.getRechargeBusinessNo()).appId(rechargeDTO.getAppId()).build();
        account = this.updateBalance((Long)rechargeDTO.getAccountId(), (UpdateBalanceBean)updateBalanceBean).account;
        if (rechargeDTO.getAwardAmount() != null) {
            updateBalanceBean = UpdateBalanceBean.builder().useAwardAmount(rechargeDTO.getAwardAmount()).transactionType(TransactionTypeEnum.AWARD).businessNo(rechargeDTO.getAwardBusinessNo()).appId(rechargeDTO.getAppId()).build();
            account = this.updateBalance((Long)rechargeDTO.getAccountId(), (UpdateBalanceBean)updateBalanceBean).account;
        }
        return account;
    }

    public Account consume(ConsumeDTO consumeDTO) {
        Account account = this.accountMapper.selectByIdWithLock(consumeDTO.getAccountId());
        if (account == null) {
            throw new IllegalArgumentException("\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        this.checkPrivilege(account);
        BigDecimal remainAmount = consumeDTO.getConsumeAmount();
        if (remainAmount.compareTo(account.getBalance().add(account.getCreditLimit()).subtract(account.getFrozenAmount())) > 0) {
            throw new IllegalArgumentException("\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u5148\u5145\u503c");
        }
        BigDecimal useRechargeAmount = BigDecimal.ZERO;
        BigDecimal useAwardAmount = BigDecimal.ZERO;
        BigDecimal userCreditLimit = BigDecimal.ZERO;
        if (remainAmount.compareTo(account.getAwardBalance()) > 0) {
            useAwardAmount = account.getAwardBalance().negate();
            if ((remainAmount = remainAmount.subtract(account.getAwardBalance())).compareTo(account.getRechargeBalance()) > 0) {
                useRechargeAmount = account.getRechargeBalance().negate();
                if ((remainAmount = remainAmount.subtract(account.getRechargeBalance())).compareTo(BigDecimal.ZERO) > 0) {
                    userCreditLimit = remainAmount.negate();
                }
            } else {
                useRechargeAmount = remainAmount.negate();
            }
        } else {
            useAwardAmount = remainAmount.negate();
        }
        UpdateBalanceBean updateBalanceBean = UpdateBalanceBean.builder().useRechargeAmount(useRechargeAmount).useAwardAmount(useAwardAmount).userCreditLimit(userCreditLimit).transactionType(TransactionTypeEnum.CONSUME).businessNo(consumeDTO.getConsumeBusinessNo()).appId(consumeDTO.getAppId()).build();
        account = this.updateBalance((Long)consumeDTO.getAccountId(), (UpdateBalanceBean)updateBalanceBean).account;
        return account;
    }

    public Account refund(RefundDTO refundDTO) {
        AccountTransaction accountTransactionEntity = this.accountTransactionMapper.selectByIdWithLock(refundDTO.getTransactionId());
        if (accountTransactionEntity == null) {
            throw new IllegalArgumentException("\u539f\u4ea4\u6613\u4e0d\u5b58\u5728");
        }
        if (accountTransactionEntity.getTransactionType() != TransactionTypeEnum.CONSUME) {
            throw new IllegalArgumentException("\u53ea\u80fd\u6d88\u8d39\u7c7b\u4ea4\u6613\u624d\u80fd\u7533\u8bf7");
        }
        if (accountTransactionEntity.getTransactionStatus() != 1) {
            throw new IllegalArgumentException("\u539f\u4ea4\u6613\u72b6\u6001\u4e0d\u5bf9");
        }
        accountTransactionEntity.setTransactionStatus(Integer.valueOf(2));
        accountTransactionEntity.setUpdateTime(new Date());
        this.accountTransactionMapper.updateById((Object)accountTransactionEntity);
        UpdateBalanceBean updateBalanceBean = UpdateBalanceBean.builder().useAwardAmount(accountTransactionEntity.getUseAwardAmount().negate()).useRechargeAmount(accountTransactionEntity.getUseRechargeAmount().negate()).userCreditLimit(accountTransactionEntity.getUseCreditLimit().negate()).transactionType(TransactionTypeEnum.REFUND).appId(refundDTO.getAppId()).businessNo("RF" + accountTransactionEntity.getTransactionNo()).build();
        return this.updateBalance((Long)accountTransactionEntity.getAccountId(), (UpdateBalanceBean)updateBalanceBean).account;
    }

    public Account rollback(RollbackDTO rollbackDTO) {
        AccountTransaction accountTransactionEntity = this.accountTransactionMapper.selectByIdWithLock(rollbackDTO.getTransactionId());
        if (accountTransactionEntity == null) {
            throw new IllegalArgumentException("\u539f\u4ea4\u6613\u4e0d\u5b58\u5728");
        }
        if (accountTransactionEntity.getTransactionType() != TransactionTypeEnum.CONSUME) {
            throw new IllegalArgumentException("\u53ea\u80fd\u6d88\u8d39\u7c7b\u4ea4\u6613\u624d\u80fd\u7533\u8bf7");
        }
        if (accountTransactionEntity.getTransactionStatus() != 1) {
            throw new IllegalArgumentException("\u539f\u4ea4\u6613\u72b6\u6001\u4e0d\u5bf9");
        }
        accountTransactionEntity.setTransactionStatus(Integer.valueOf(3));
        accountTransactionEntity.setUpdateTime(new Date());
        this.accountTransactionMapper.updateById((Object)accountTransactionEntity);
        UpdateBalanceBean updateBalanceBean = UpdateBalanceBean.builder().useAwardAmount(accountTransactionEntity.getUseAwardAmount().negate()).useRechargeAmount(accountTransactionEntity.getUseRechargeAmount().negate()).userCreditLimit(accountTransactionEntity.getUseCreditLimit().negate()).transactionType(TransactionTypeEnum.ROLLBACK).appId(rollbackDTO.getAppId()).businessNo("RB" + accountTransactionEntity.getTransactionNo()).build();
        return this.updateBalance((Long)accountTransactionEntity.getAccountId(), (UpdateBalanceBean)updateBalanceBean).account;
    }

    public Account frozen(Long accountId) {
        Account account = (Account)this.accountMapper.selectById((Serializable)accountId);
        account.setStatus(Integer.valueOf(0));
        account.setUpdateTime(new Date());
        this.accountMapper.updateById((Object)account);
        return account;
    }

    public AccountTransaction adjustBalance(Long accountId, BigDecimal adjustRechargeAmount, BigDecimal adjustAwardAmount, String businessNo) {
        UpdateBalanceBean updateBalanceBean = UpdateBalanceBean.builder().useAwardAmount(adjustAwardAmount == null ? BigDecimal.ZERO : adjustAwardAmount).useRechargeAmount(adjustRechargeAmount == null ? BigDecimal.ZERO : adjustRechargeAmount).transactionType(TransactionTypeEnum.ADJUST).businessNo(businessNo).build();
        return this.updateBalance((Long)accountId, (UpdateBalanceBean)updateBalanceBean).accountTransaction;
    }

    public List<Account> list(AccountSearch account) {
        return this.list(this.getQueryWrapper(account));
    }

    public IPage<Account> findListByPage(AccountSearch search, Integer pageNo, Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        return ((AccountMapper)this.baseMapper).selectPage((IPage)page, this.getQueryWrapper(search));
    }

    private Wrapper<Account> getQueryWrapper(AccountSearch account) {
        QueryWrapper wrapper = new QueryWrapper();
        if (null != account.getId()) {
            wrapper.eq((Object)"id", (Object)account.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)account.getAccountNo())) {
            wrapper.eq((Object)"account_no", (Object)account.getAccountNo());
        }
        if (StringUtils.isNotBlank((CharSequence)account.getAccountName())) {
            wrapper.like((Object)"account_name", (Object)account.getAccountName());
        }
        if (null != account.getTenantId()) {
            wrapper.eq((Object)"tenant_id", (Object)account.getTenantId());
        }
        wrapper.orderByDesc((Object)"id");
        return wrapper;
    }

    private UpdateBalanceResult updateBalance(Long accountId, UpdateBalanceBean updateBalance) {
        Account account = this.accountMapper.selectByIdWithLock(accountId);
        if (updateBalance.getTotalAmount().compareTo(BigDecimal.ZERO) == 0) {
            return new UpdateBalanceResult(this, account);
        }
        BigDecimal beforeBalance = account.getBalance();
        account.setRechargeBalance(account.getRechargeBalance().add(updateBalance.getUseRechargeAmount()));
        account.setAwardBalance(account.getAwardBalance().add(updateBalance.getUseAwardAmount()));
        account.setBalance(account.getBalance().add(updateBalance.getTotalAmount()));
        account.setUpdateTime(new Date());
        this.accountMapper.updateById((Object)account);
        AccountTransaction a = this.buildEmptyTransaction(account, updateBalance);
        a.setBeforeBalance(beforeBalance);
        a.setAmount(updateBalance.getTotalAmount());
        a.setRemainBalance(account.getBalance());
        a.setUseAwardAmount(updateBalance.getUseAwardAmount());
        a.setUseRechargeAmount(updateBalance.getUseRechargeAmount());
        a.setUseCreditLimit(updateBalance.getUserCreditLimit());
        this.accountTransactionMapper.insert((Object)a);
        return new UpdateBalanceResult(this, account, a);
    }

    public AccountTransaction buildEmptyTransaction(Account account, UpdateBalanceBean updateBalanceBean) {
        return this.buildEmptyTransaction(account, updateBalanceBean.getTransactionType(), updateBalanceBean.getBusinessNo(), updateBalanceBean.getAppId());
    }

    public AccountTransaction buildEmptyTransaction(Account account, TransactionTypeEnum transactionType, String businessNo) {
        return this.buildEmptyTransaction(account, transactionType, businessNo, null);
    }

    public AccountTransaction buildEmptyTransaction(Account account, TransactionTypeEnum transactionType, String businessNo, String appId) {
        AccountTransaction a = new AccountTransaction();
        a.setAccountId(account.getId());
        a.setTenantId(account.getTenantId());
        a.setCompanyId(account.getCompanyId());
        if (appId == null) {
            a.setAppId("-");
            a.setAppName("-");
            a.setAppBusinessCode("-");
            a.setAppBusinessName("-");
        } else {
            BusinessConfigBO bo = this.businessConfigMapper.selectByAppIdAndBusinessCode(appId, transactionType.getCode());
            if (bo == null) {
                throw new IllegalStateException("\u65e0\u6743\u9650\uff0c\u8bf7\u5148\u914d\u7f6e\u6743\u9650");
            }
            a.setAppId(bo.getAppId());
            a.setAppName(bo.getAppName());
            a.setAppBusinessCode(bo.getBusinessCode());
            a.setAppBusinessName(bo.getBusinessName());
        }
        a.setBusinessNo(businessNo);
        a.setTransactionNo(AppUtil.generateTransNo());
        a.setTransactionType(transactionType);
        a.setBeforeBalance(BigDecimal.ZERO);
        a.setAmount(BigDecimal.ZERO);
        a.setRemainBalance(BigDecimal.ZERO);
        a.setUseAwardAmount(BigDecimal.ZERO);
        a.setUseRechargeAmount(BigDecimal.ZERO);
        a.setUseCreditLimit(BigDecimal.ZERO);
        a.setCreateBy(UserUtil.getUserInfo().getUsername());
        a.setCreateTime(new Date());
        a.setUpdateBy(UserUtil.getUserInfo().getUsername());
        a.setUpdateTime(new Date());
        a.setTransactionStatus(Integer.valueOf(1));
        a.setId(IdUtil.nextId());
        return a;
    }

    public Account changeStatus(Long tenantId, Long accountId, Integer status) {
        Account accountEntity = (Account)this.accountMapper.selectById((Serializable)accountId);
        if (accountEntity == null) {
            throw new IllegalArgumentException("\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        if (null == AccountStatusEnum.fromCode((Integer)status)) {
            throw new IllegalArgumentException("\u53c2\u6570status:" + status + "\uff0c\u4e0d\u7b26\u5408\u89c4\u5b9a\u3002");
        }
        accountEntity.setStatus(status);
        accountEntity.setUpdateBy(UserUtil.getUserInfo().getUsername());
        accountEntity.setUpdateTime(new Date());
        this.accountMapper.updateById((Object)accountEntity);
        return accountEntity;
    }

    public Account frozenAmount(Long tenantId, FreezeDTO freezeDTO) {
        Account account = this.accountMapper.selectByIdWithLock(freezeDTO.getAccountId());
        if (account == null) {
            throw new IllegalArgumentException("\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        if (freezeDTO.getFrozenAmount() == null || freezeDTO.getFrozenAmount().doubleValue() <= 0.0 || freezeDTO.getFrozenAmount().scale() > 2) {
            throw new IllegalArgumentException("\u51bb\u7ed3\u91d1\u989d\u975e\u6cd5");
        }
        if (freezeDTO.getFrozenAmount().compareTo(account.getBalance()) > 0) {
            throw new IllegalArgumentException("\u51bb\u7ed3\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u53ef\u7528\u4f59\u989d");
        }
        account.setFrozenAmount(freezeDTO.getFrozenAmount());
        account.setUpdateBy(UserUtil.getUserInfo().getUsername());
        account.setUpdateTime(new Date());
        this.accountMapper.updateById((Object)account);
        return account;
    }

    public Account creditLimit(Long tenantId, CreditDTO creditDTO) {
        Account account = this.accountMapper.selectByIdWithLock(creditDTO.getAccountId());
        if (account == null) {
            throw new IllegalArgumentException("\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        if (creditDTO.getCreditAmount() == null || creditDTO.getCreditAmount().doubleValue() < 0.0 || creditDTO.getCreditAmount().scale() > 2) {
            throw new IllegalArgumentException("\u6388\u4fe1\u989d\u5ea6\u975e\u6cd5");
        }
        account.setCreditLimit(creditDTO.getCreditAmount());
        account.setUpdateBy(UserUtil.getUserInfo().getUsername());
        account.setUpdateTime(new Date());
        this.accountMapper.updateById((Object)account);
        return account;
    }

    private void checkPrivilege(Account account) {
        if (account.getStatus() == 0) {
            throw new IllegalStateException("\u5f53\u524d\u8d26\u6237\u5df2\u7ecf\u88ab\u51bb\u7ed3\uff0c\u65e0\u6cd5\u4ea4\u6613");
        }
    }

    public AccountServiceImpl(AccountMapper accountMapper, AccountTransactionMapper accountTransactionMapper, BusinessConfigMapper businessConfigMapper) {
        this.accountMapper = accountMapper;
        this.accountTransactionMapper = accountTransactionMapper;
        this.businessConfigMapper = businessConfigMapper;
    }
}

