/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.bill.account.bo.AccountTransactionBO;
import com.xforceplus.bill.account.bo.AccountTransactionData;
import com.xforceplus.bill.account.controller.search.AccountTransactionSearch;
import com.xforceplus.bill.account.dao.AccountTransactionMapper;
import com.xforceplus.bill.account.entity.AccountTransaction;
import com.xforceplus.bill.account.service.IAccountTransactionService;
import com.xforceplus.bill.core.util.IdUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;

@Service
public class AccountTransactionServiceImpl
extends ServiceImpl<AccountTransactionMapper, AccountTransaction>
implements IAccountTransactionService {
    public IPage<AccountTransactionBO> findListByPage(AccountTransactionSearch condition, Integer pageNo, Integer pageSize) {
        int total = ((AccountTransactionMapper)this.baseMapper).count(condition);
        List data = ((AccountTransactionMapper)this.baseMapper).pageQuery(Integer.valueOf((pageNo - 1) * pageSize), pageSize, condition);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue(), (long)total);
        page.setRecords(data);
        return page;
    }

    private Wrapper<AccountTransaction> getQueryWrapper(AccountTransactionSearch search) {
        QueryWrapper wrapper = new QueryWrapper();
        if (null != search.getAccountId()) {
            wrapper.eq((Object)"account_id", (Object)search.getAccountId());
        }
        if (null != search.getStartDate()) {
            wrapper.ge((Object)"create_time", (Object)search.getStartDate());
        }
        if (null != search.getEndDate()) {
            wrapper.le((Object)"create_time", (Object)new DateTime((Object)search.getEndDate()).plusDays(1).toDate());
        }
        wrapper.orderByDesc((Object)"id");
        return wrapper;
    }

    public int add(AccountTransaction accountTransaction) {
        accountTransaction.setId(IdUtil.nextId());
        return ((AccountTransactionMapper)this.baseMapper).insert((Object)accountTransaction);
    }

    public int delete(Long id) {
        return ((AccountTransactionMapper)this.baseMapper).deleteById((Serializable)id);
    }

    public int updateData(AccountTransaction accountTransaction) {
        return ((AccountTransactionMapper)this.baseMapper).updateById((Object)accountTransaction);
    }

    public AccountTransaction findById(Long id) {
        return (AccountTransaction)((AccountTransactionMapper)this.baseMapper).selectById((Serializable)id);
    }

    public List<AccountTransactionData> queryTransaction(Long accountId, Date startDate, Date endDate) {
        return ((AccountTransactionMapper)this.baseMapper).queryExportTransaction(accountId, startDate, new DateTime((Object)endDate).plusDays(1).toDate());
    }
}

