/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.bill.account.bo.BusinessConfigBO;
import com.xforceplus.bill.account.controller.search.BusinessConfigSearch;
import com.xforceplus.bill.account.dao.BusinessConfigMapper;
import com.xforceplus.bill.account.entity.BusinessConfig;
import com.xforceplus.bill.account.exception.ParameterException;
import com.xforceplus.bill.account.service.IBusinessConfigService;
import com.xforceplus.bill.account.service.IBusinessTypeService;
import com.xforceplus.bill.core.util.IdUtil;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BusinessConfigServiceImpl
extends ServiceImpl<BusinessConfigMapper, BusinessConfig>
implements IBusinessConfigService {
    @Autowired
    private IBusinessTypeService businessTypeService;

    public IPage<BusinessConfigBO> findListByPage(Integer page, Integer pageCount, BusinessConfigSearch businessConfigSearch) {
        QueryWrapper condition = new QueryWrapper();
        condition.like(StringUtils.isNotBlank((CharSequence)businessConfigSearch.getAppName()), (Object)"app_name", (Object)businessConfigSearch.getAppName());
        condition.eq(StringUtils.isNotBlank((CharSequence)businessConfigSearch.getAppId()), (Object)"app_id", (Object)businessConfigSearch.getAppId());
        int total = ((BusinessConfigMapper)this.baseMapper).selectCount((Wrapper)condition);
        List data = ((BusinessConfigMapper)this.baseMapper).pageQuery(Integer.valueOf((page - 1) * pageCount), pageCount, businessConfigSearch);
        Page result = new Page((long)page.intValue(), (long)pageCount.intValue(), (long)total);
        result.setRecords(data);
        return result;
    }

    public int add(BusinessConfig businessConfig) {
        businessConfig.setId(IdUtil.nextId());
        return ((BusinessConfigMapper)this.baseMapper).insert((Object)businessConfig);
    }

    public int delete(Long id) {
        return ((BusinessConfigMapper)this.baseMapper).deleteById((Serializable)id);
    }

    public int updateData(BusinessConfig businessConfig) {
        return ((BusinessConfigMapper)this.baseMapper).updateById((Object)businessConfig);
    }

    public BusinessConfig findById(Long id) {
        return (BusinessConfig)((BusinessConfigMapper)this.baseMapper).selectById((Serializable)id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void save(List<BusinessConfig> businessConfigs) {
        List businessIds = businessConfigs.stream().map(BusinessConfig::getBusinessId).collect(Collectors.toList());
        List businessCodes = businessConfigs.stream().map(BusinessConfig::getBusinessCode).collect(Collectors.toList());
        QueryWrapper condition = new QueryWrapper();
        condition.in((Object)"id", businessIds);
        condition.in((Object)"code", businessCodes);
        int count = this.businessTypeService.count((Wrapper)condition);
        if (businessIds.size() != count) {
            throw new ParameterException("\u4e1a\u52a1\u914d\u7f6e\u4ee3\u7801\u4e0d\u5b58\u5728\u6216\u8005\u91cd\u590d!");
        }
        try {
            this.saveBatch(businessConfigs);
        }
        catch (DuplicateKeyException e) {
            throw new ParameterException("\u5df2\u5b58\u5728\u4ea7\u7ebf\u914d\u7f6e!\u65e0\u9700\u91cd\u590d");
        }
    }

    public void update(BusinessConfig businessConfig) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"id", (Object)businessConfig.getBusinessId());
        condition.eq((Object)"code", (Object)businessConfig.getBusinessCode());
        if (this.businessTypeService.count((Wrapper)condition) == 0) {
            throw new ParameterException("\u4e1a\u52a1\u914d\u7f6e\u4ee3\u7801\u4e0d\u5b58\u5728\u6216\u8005\u91cd\u590d!");
        }
        try {
            int count = ((BusinessConfigMapper)this.baseMapper).updateById((Object)businessConfig);
            if (count == 0) {
                throw new ParameterException("\u914d\u7f6e\u4e0d\u5b58\u5728!");
            }
        }
        catch (DuplicateKeyException e) {
            throw new ParameterException("\u5df2\u5b58\u5728\u4ea7\u7ebf\u914d\u7f6e!\u65e0\u9700\u91cd\u590d");
        }
    }
}

