/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.service.impl;

import com.alibaba.fastjson.JSON;
import com.xforceplus.bill.account.api.vo.DefaultResponse;
import com.xforceplus.bill.account.bo.PageCompanyBo;
import com.xforceplus.bill.account.bo.PageTenantBo;
import com.xforceplus.bill.account.service.IUserCenterService;
import com.xforceplus.domain.company.CompanyDto;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.tenant.security.client.service.ClientService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class UserCenterServiceImpl
implements IUserCenterService {
    private static final Logger log = LoggerFactory.getLogger(UserCenterServiceImpl.class);
    @Value(value="${xforce.tenant.service.tenant_service_global}")
    private String gatewayUrl;
    @Value(value="${tower.userCenter.clientId}")
    private String clientId;
    @Value(value="${tower.userCenter.secret}")
    private String secret;
    @Autowired
    private ClientService clientService;
    @Autowired
    private RestTemplate restTemplate;

    public TenantDto findTenantById(Long tenantId) {
        String tenantUrl = this.gatewayUrl + "/api/global/v2/tenants/" + tenantId + "?extensionFlag=true&withExtendParams=extensions";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String appToken = this.clientService.token();
        headers.set("x-app-token", appToken);
        log.info("[\u8bf7\u6c42\u7528\u6237\u4e2d\u5fc3\u83b7\u53d6tenant\u4fe1\u606f]:{}", (Object)tenantUrl);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity resp = this.restTemplate.exchange(tenantUrl, HttpMethod.GET, httpEntity, Map.class, new Object[0]);
            DefaultResponse defaultResponse = (DefaultResponse)JSON.parseObject((String)JSON.toJSONString((Object)resp.getBody()), DefaultResponse.class);
            if ("1".equalsIgnoreCase(defaultResponse.getCode())) {
                TenantDto tenantDto = (TenantDto)JSON.parseObject((String)defaultResponse.getResult().toString(), TenantDto.class);
                return tenantDto;
            }
        }
        catch (Exception e) {
            log.info("findTenantById.exception:" + e.getMessage());
        }
        return null;
    }

    public TenantDto findTenantByCode(String tenantCode) {
        PageTenantBo pageDto;
        String tenantUrl = this.gatewayUrl + "/api/global/v2/tenants?page=1&row=1&tenantCode=" + tenantCode + "&extensionFlag=true&withExtendParams=extensions";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String appToken = this.clientService.token();
        headers.set("x-app-token", appToken);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resp = this.restTemplate.exchange(tenantUrl, HttpMethod.GET, httpEntity, Map.class, new Object[0]);
        DefaultResponse defaultResponse = (DefaultResponse)JSON.parseObject((String)JSON.toJSONString((Object)resp.getBody()), DefaultResponse.class);
        if ("1".equalsIgnoreCase(defaultResponse.getCode()) && (pageDto = (PageTenantBo)JSON.parseObject((String)defaultResponse.getResult().toString(), PageTenantBo.class)).getSize() == 1 && pageDto.getContent().size() == 1) {
            return (TenantDto)pageDto.getContent().get(0);
        }
        return null;
    }

    public CompanyDto findCompanyById(Long companyId) {
        String companyUrl = this.gatewayUrl + "/api/global/v2/companies/" + companyId + "?extensionFlag=true&withExtendParams=extensions";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String appToken = this.clientService.token();
        headers.set("x-app-token", appToken);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resp = this.restTemplate.exchange(companyUrl, HttpMethod.GET, httpEntity, Map.class, new Object[0]);
        DefaultResponse defaultResponse = (DefaultResponse)JSON.parseObject((String)JSON.toJSONString((Object)resp.getBody()), DefaultResponse.class);
        if ("1".equalsIgnoreCase(defaultResponse.getCode())) {
            CompanyDto companyDto = (CompanyDto)JSON.parseObject((String)defaultResponse.getResult().toString(), CompanyDto.class);
            return companyDto;
        }
        return null;
    }

    public CompanyDto findCompanyBy(String taxNum, String companyName) {
        PageCompanyBo pageDto;
        log.info("\u6839\u636etaxNum:{} \u5411\u7528\u6237\u4e2d\u5fc3\u67e5\u8be2\u516c\u53f8\u4fe1\u606f", (Object)taxNum);
        String companyUrl = this.gatewayUrl + "/api/global/v2/companies?page=1&row=1&taxNum=" + taxNum + "&companyName=" + companyName;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String appToken = this.clientService.token();
        headers.set("x-app-token", appToken);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resp = this.restTemplate.exchange(companyUrl, HttpMethod.GET, httpEntity, Map.class, new Object[0]);
        DefaultResponse defaultResponse = (DefaultResponse)JSON.parseObject((String)JSON.toJSONString((Object)resp.getBody()), DefaultResponse.class);
        if ("1".equalsIgnoreCase(defaultResponse.getCode()) && (pageDto = (PageCompanyBo)JSON.parseObject((String)defaultResponse.getResult().toString(), PageCompanyBo.class)).getSize() == 1 && pageDto.getContent().size() == 1) {
            return (CompanyDto)pageDto.getContent().get(0);
        }
        return null;
    }
}

