/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bill.account.sqs;

import com.alibaba.fastjson.JSON;
import com.xforceplus.bill.account.api.dto.RechargeDTO;
import com.xforceplus.bill.account.bo.PaymentMessage;
import com.xforceplus.bill.account.service.IAccountService;
import com.xforceplus.phoenix.sqs.BaseSQSListener;
import com.xforceplus.xplat.aws.spring.annotation.SQSListener;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@SQSListener(queueName="bill-payment")
public class PaymentListener
extends BaseSQSListener {
    private static final Logger log = LoggerFactory.getLogger(PaymentListener.class);
    @Autowired
    private IAccountService accountService;

    public boolean onMessage(String messageId, Map headers, String messageBody) {
        log.info("\u6536\u5230\u652f\u4ed8\u6210\u529f\u6d88\u606fmessageId = {} , message = {}", (Object)messageId, (Object)messageBody);
        PaymentMessage paymentMessage = (PaymentMessage)JSON.parseObject((String)messageBody, PaymentMessage.class);
        RechargeDTO rechargeDTO = new RechargeDTO();
        rechargeDTO.setAccountId(Long.valueOf(paymentMessage.getBizParam()));
        rechargeDTO.setRechargeBusinessNo(paymentMessage.getOrderId().toString());
        rechargeDTO.setRechargeAmount(paymentMessage.getOrderAmt());
        try {
            this.accountService.recharge(rechargeDTO);
        }
        catch (Exception e) {
            log.error(rechargeDTO.getAccountId() + "\u6536\u5230\u652f\u4ed8\u6210\u529f\u6d88\u606f\u5145\u503c\u5931\u8d25", (Throwable)e);
            return false;
        }
        return true;
    }
}

