package com.xforceplus.phoenix.split.api;


import com.xforceplus.phoenix.split.model.BaseResponse;
import com.xforceplus.phoenix.split.model.OrderInfo;
import com.xforceplus.phoenix.split.model.SplitOrderParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Api(value = "split_order")
public interface OrderSplitApi {

    @ApiOperation(value = "订单拆分接口")
    @RequestMapping(value = "/{tenantId}/invoice/v1/pre-invoices/orders", produces = {"application/json"}, method = RequestMethod.POST)
    BaseResponse<List<OrderInfo>> sendSplitMsg(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") long tenantId,
                                               @ApiParam(required = true, value = "产品线id") @RequestParam("appId") long appId,
                                               @ApiParam(required = true, value = "订单规则信息") @RequestBody @Valid SplitOrderParam splitOrderParam);
}
