package com.xforceplus.phoenix.split.api;

import com.xforceplus.phoenix.split.model.BaseResponse;
import com.xforceplus.phoenix.split.model.CreatePreInvoiceParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.async.DeferredResult;

import javax.validation.Valid;

@Api(value = "pre_invoice")
public interface PreInvoiceGenerateApi {

    @ApiOperation(value = "发送拆票请求新接口")
    @RequestMapping(value = "/{tenantId}/invoice/v1/pre-invoices", produces = {"application/json"}, method = RequestMethod.POST)
    DeferredResult<BaseResponse>   sendSplitMsg(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") long tenantId,
                                              @ApiParam(required = true, value = "产品线id") @RequestParam("appId") long appId,
                                              @ApiParam(value = "模式, sync = 同步获取结果, callback=异步获取结果接口返回为txId,同步接口返回为预制发票数据") @RequestParam(value = "returnMode", required = false) String returnMode,
                                              @ApiParam(value = "税盘类型：1 百望单盘 2 百望服务器 3 航信单盘 4 航信服务器 5 虚拟UKey设备 8 税务UKey设备 7 税务证书") @RequestParam(value = "taxDeviceType", required = false) String taxDeviceType,
                                              @ApiParam(required = true, value = "单据规则信息") @RequestBody @Valid CreatePreInvoiceParam createPreInvoiceParam);


    @Deprecated
    @ApiOperation(value = "发送拆票请求老接口,兼容没有升级的客户,即将废弃")
    @RequestMapping(value = "/{tenantId}/{appId}/invoice/v1/pre-invoices", produces = {"application/json"}, method = RequestMethod.POST)
    BaseResponse<String> sendSplitMsgOld(@ApiParam(required = true, value = "租户id") @PathVariable("tenantId") long tenantId,
                                      @ApiParam(required = true, value = "产品线id") @PathVariable("appId") long appId,
                                      @ApiParam(required = true, value = "单据规则信息") @RequestBody @Valid CreatePreInvoiceParam createPreInvoiceParam);

}
