package com.xforceplus.phoenix.split.model;

import io.swagger.annotations.ApiModel;

@ApiModel
public class BaseResponse<T> {

    public static final String SUCCESS_CODE = "BSCTZZ0001";

    public static final String PARAM_ERROR = "BSCTZZ0400";

    public static final String UNIT_PRICE_ERROR = "BSCTZZ0401";

    public static final String NOT_FOUND = "BSCTZZ0404";

    public static final String SYSTEM_ERROR = "BSCTZZ0500";

    private String code;

    private String message;

    private T result;

    public static <E> BaseResponse<E> Ok() {
        BaseResponse<E> baseResponse = new BaseResponse<>();
        baseResponse.setCode(SUCCESS_CODE);
        baseResponse.setMessage("success");
        return baseResponse;
    }

    public static <E> BaseResponse<E> Ok(String message) {
        BaseResponse<E> baseResponse = new BaseResponse<>();
        baseResponse.setCode(SUCCESS_CODE);
        baseResponse.setMessage(message);
        return baseResponse;
    }


    public static BaseResponse  fail(String msg) {
        BaseResponse baseResponse = new BaseResponse<>();
        baseResponse.setCode(SYSTEM_ERROR);
        baseResponse.setMessage(msg);
        return baseResponse;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    @Override
    public String toString() {
        return "BaseResponse{" +
                "code='" + code + '\'' +
                ", message='" + message + '\'' +
                ", result=" + result +
                '}';
    }
}
