package com.xforceplus.phoenix.split.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 单据信息
 */
@ApiModel
public class BillInfo {

    @ApiModelProperty("批次号")
    private Long batchNo;

    @ApiModelProperty("单据id")
    @NotNull(message = "单据id不能为空")
    private String salesbillId;

    @ApiModelProperty("导入批次号")
    private String importBatchNo;

    @ApiModelProperty("单据号")
    private String salesbillNo;

    @ApiModelProperty("销方编号")
    private String sellerNo;

    @ApiModelProperty("销方名称")
    private String sellerName;

    @ApiModelProperty("销方税号")
    private String sellerTaxNo;

    @ApiModelProperty("销方电话")
    private String sellerTel;

    @ApiModelProperty("销方地址")
    private String sellerAddress;

    @ApiModelProperty("销方银行名称")
    private String sellerBankName;

    @ApiModelProperty("销方银行账号")
    private String sellerBankAccount;

    @ApiModelProperty("销方集团id")
    private Long sellerTenantId;

    @ApiModelProperty("销方租户id")
    private Long sellerGroupId;

    @ApiModelProperty("销方id")
    private Long sellerId;

    @ApiModelProperty("购方编号")
    private String purchaserNo;

    @ApiModelProperty("购方名称")
    private String purchaserName;

    @ApiModelProperty("购方税号")
    private String purchaserTaxNo;

    @ApiModelProperty("购方电话")
    private String purchaserTel;

    @ApiModelProperty("购方地址")
    private String purchaserAddress;

    @ApiModelProperty("购方银行名称")
    private String purchaserBankName;

    @ApiModelProperty("购方银行账号")
    private String purchaserBankAccount;

    @ApiModelProperty("购方集团id")
    private Long purchaserTenantId;

    @ApiModelProperty("购方租户id")
    private Long purchaserGroupId;

    @ApiModelProperty("购方id")
    private Long purchaserId;

    @ApiModelProperty("机构")
    private String systemOrig;

    @ApiModelProperty("业务单据类型")
    private String businessBillType;

    @ApiModelProperty("单据类型")
    private String salesbillType;

    @ApiModelProperty(value = "发票类型", required = true)
    @NotBlank(message = "发票类型不能为空")
    private String invoiceType;

    @ApiModelProperty(value = "价格方式", required = true)
    @NotNull(message = "价格方式不能为空")
    private Integer priceMethod;

    @ApiModelProperty(value = "含税金额", required = true)
    @NotNull(message = "含税金额不能为空")
    private BigDecimal amountWithTax;

    @ApiModelProperty(value = "不含税金额", required = true)
    @NotNull(message = "不含税金额不能为空")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty(value = "税额", required = true)
    @NotNull(message = "税额不能为空")
    private BigDecimal taxAmount;

    @ApiModelProperty("原发票号码")
    private String originInvoiceNo;

    @ApiModelProperty("原发票代码")
    private String originInvoiceCode;

    @ApiModelProperty("复核人")
    private String checkerName;

    @ApiModelProperty("收款人")
    private String cashierName;

    @ApiModelProperty("开票人")
    private String invoicerName;

    @ApiModelProperty("接收人邮箱")
    private String receiveUserEmail;

    @ApiModelProperty("接收人电话")
    private String receiveUserTel;

    @ApiModelProperty("组织结构id")
    private Long sysOrgId;

    @ApiModelProperty("用户Id 下发数据需要  由属地直接传过来")
    private String customerNo;

    @ApiModelProperty("业务单备注")
    private String remark;

    @ApiModelProperty(value = "红字信息表编号")
    private String redNotificationNo;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "合同号")
    private String contractNo;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

    private String ext6;

    private String ext7;

    private String ext8;

    private String ext9;

    private String ext10;

    private String ext11;

    private String ext12;

    private String ext13;

    private String ext14;

    private String ext15;

    private String ext16;

    private String ext17;

    private String ext18;

    private String ext19;

    private String ext20;

    private String ext21;

    private String ext22;

    private String ext23;

    private String ext24;

    private String ext25;

    @ApiModelProperty("透传扩展属性")
    @Length(max = 200, message = "透传扩展属性长度不能超过200")
    private String extInfo;

    @ApiModelProperty(value = "单据明细", required = true)
    @NotEmpty(message = "单据明细不能为空")
    @Valid
    private List<BillItem> billItems;


    public Long getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(Long batchNo) {
        this.batchNo = batchNo;
    }

    public String getSalesbillId() {
        return salesbillId;
    }

    public void setSalesbillId(String salesbillId) {
        this.salesbillId = salesbillId;
    }

    public String getImportBatchNo() {
        return importBatchNo;
    }

    public void setImportBatchNo(String importBatchNo) {
        this.importBatchNo = importBatchNo;
    }

    public String getSalesbillNo() {
        return salesbillNo;
    }

    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
    }

    public String getSellerNo() {
        return sellerNo;
    }

    public void setSellerNo(String sellerNo) {
        this.sellerNo = sellerNo;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    public String getSellerTel() {
        return sellerTel;
    }

    public void setSellerTel(String sellerTel) {
        this.sellerTel = sellerTel;
    }

    public String getSellerAddress() {
        return sellerAddress;
    }

    public void setSellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress;
    }

    public String getSellerBankName() {
        return sellerBankName;
    }

    public void setSellerBankName(String sellerBankName) {
        this.sellerBankName = sellerBankName;
    }

    public String getSellerBankAccount() {
        return sellerBankAccount;
    }

    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
    }

    public Long getSellerTenantId() {
        return sellerTenantId;
    }

    public void setSellerTenantId(Long sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
    }

    public Long getSellerGroupId() {
        return sellerGroupId;
    }

    public void setSellerGroupId(Long sellerGroupId) {
        this.sellerGroupId = sellerGroupId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getPurchaserNo() {
        return purchaserNo;
    }

    public void setPurchaserNo(String purchaserNo) {
        this.purchaserNo = purchaserNo;
    }

    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    public String getPurchaserTel() {
        return purchaserTel;
    }

    public void setPurchaserTel(String purchaserTel) {
        this.purchaserTel = purchaserTel;
    }

    public String getPurchaserAddress() {
        return purchaserAddress;
    }

    public void setPurchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress;
    }

    public String getPurchaserBankName() {
        return purchaserBankName;
    }

    public void setPurchaserBankName(String purchaserBankName) {
        this.purchaserBankName = purchaserBankName;
    }

    public String getPurchaserBankAccount() {
        return purchaserBankAccount;
    }

    public void setPurchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount;
    }

    public Long getPurchaserTenantId() {
        return purchaserTenantId;
    }

    public void setPurchaserTenantId(Long purchaserTenantId) {
        this.purchaserTenantId = purchaserTenantId;
    }

    public Long getPurchaserGroupId() {
        return purchaserGroupId;
    }

    public void setPurchaserGroupId(Long purchaserGroupId) {
        this.purchaserGroupId = purchaserGroupId;
    }

    public Long getPurchaserId() {
        return purchaserId;
    }

    public void setPurchaserId(Long purchaserId) {
        this.purchaserId = purchaserId;
    }

    public String getSystemOrig() {
        return systemOrig;
    }

    public void setSystemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
    }

    public String getBusinessBillType() {
        return businessBillType;
    }

    public void setBusinessBillType(String businessBillType) {
        this.businessBillType = businessBillType;
    }

    public String getSalesbillType() {
        return salesbillType;
    }

    public void setSalesbillType(String salesbillType) {
        this.salesbillType = salesbillType;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Integer getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(Integer priceMethod) {
        this.priceMethod = priceMethod;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getOriginInvoiceNo() {
        return originInvoiceNo;
    }

    public void setOriginInvoiceNo(String originInvoiceNo) {
        this.originInvoiceNo = originInvoiceNo;
    }

    public String getOriginInvoiceCode() {
        return originInvoiceCode;
    }

    public void setOriginInvoiceCode(String originInvoiceCode) {
        this.originInvoiceCode = originInvoiceCode;
    }

    public String getCheckerName() {
        return checkerName;
    }

    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }

    public String getCashierName() {
        return cashierName;
    }

    public void setCashierName(String cashierName) {
        this.cashierName = cashierName;
    }

    public String getInvoicerName() {
        return invoicerName;
    }

    public void setInvoicerName(String invoicerName) {
        this.invoicerName = invoicerName;
    }

    public String getReceiveUserEmail() {
        return receiveUserEmail;
    }

    public void setReceiveUserEmail(String receiveUserEmail) {
        this.receiveUserEmail = receiveUserEmail;
    }

    public String getReceiveUserTel() {
        return receiveUserTel;
    }

    public void setReceiveUserTel(String receiveUserTel) {
        this.receiveUserTel = receiveUserTel;
    }

    public Long getSysOrgId() {
        return sysOrgId;
    }

    public void setSysOrgId(Long sysOrgId) {
        this.sysOrgId = sysOrgId;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }


    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

    public String getExt9() {
        return ext9;
    }

    public void setExt9(String ext9) {
        this.ext9 = ext9;
    }

    public String getExt10() {
        return ext10;
    }

    public void setExt10(String ext10) {
        this.ext10 = ext10;
    }

    public String getExt11() {
        return ext11;
    }

    public void setExt11(String ext11) {
        this.ext11 = ext11;
    }

    public String getExt12() {
        return ext12;
    }

    public void setExt12(String ext12) {
        this.ext12 = ext12;
    }

    public String getExt13() {
        return ext13;
    }

    public void setExt13(String ext13) {
        this.ext13 = ext13;
    }

    public String getExt14() {
        return ext14;
    }

    public void setExt14(String ext14) {
        this.ext14 = ext14;
    }

    public String getExt15() {
        return ext15;
    }

    public void setExt15(String ext15) {
        this.ext15 = ext15;
    }

    public String getExt16() {
        return ext16;
    }

    public void setExt16(String ext16) {
        this.ext16 = ext16;
    }

    public String getExt17() {
        return ext17;
    }

    public void setExt17(String ext17) {
        this.ext17 = ext17;
    }

    public String getExt18() {
        return ext18;
    }

    public void setExt18(String ext18) {
        this.ext18 = ext18;
    }

    public String getExt19() {
        return ext19;
    }

    public void setExt19(String ext19) {
        this.ext19 = ext19;
    }

    public String getExt20() {
        return ext20;
    }

    public void setExt20(String ext20) {
        this.ext20 = ext20;
    }

    public String getExt21() {
        return ext21;
    }

    public void setExt21(String ext21) {
        this.ext21 = ext21;
    }

    public String getExt22() {
        return ext22;
    }

    public void setExt22(String ext22) {
        this.ext22 = ext22;
    }

    public String getExt23() {
        return ext23;
    }

    public void setExt23(String ext23) {
        this.ext23 = ext23;
    }

    public String getExt24() {
        return ext24;
    }

    public void setExt24(String ext24) {
        this.ext24 = ext24;
    }

    public String getExt25() {
        return ext25;
    }

    public void setExt25(String ext25) {
        this.ext25 = ext25;
    }

    public List<BillItem> getBillItems() {
        return billItems;
    }

    public void setBillItems(List<BillItem> billItems) {
        this.billItems = billItems;
    }

    public String getRedNotificationNo() {
        return redNotificationNo;
    }

    public void setRedNotificationNo(String redNotificationNo) {
        this.redNotificationNo = redNotificationNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getContractNo() {
        return contractNo;
    }

    public void setContractNo(String contractNo) {
        this.contractNo = contractNo;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }
}
