package com.xforceplus.phoenix.split.model;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@ApiModel
public class CreatePreInvoiceParam {

    @ApiModelProperty(value = "单据信息", required = true)
    @NotNull(message = "单据信息不能为空")
    @Valid
    private BillInfo billInfo;

    @ApiModelProperty(value = "规则信息", required = true)
    @NotNull(message = "规则信息不能为空")
    @Valid
    private SplitRule rule;

    @ApiModelProperty(value = "路由key", required = true)
    @NotBlank(message = "路由key不能为空")
    private String routingKey;

    @ApiModelProperty("规则code, 为空表示使用默认的")
    private String ruleCode;

    private String txId;

    public BillInfo getBillInfo() {
        return billInfo;
    }

    public void setBillInfo(BillInfo billInfo) {
        this.billInfo = billInfo;
    }

    public SplitRule getRule() {
        return rule;
    }

    public void setRule(SplitRule rule) {
        this.rule = rule;
    }

    public String getRoutingKey() {
        return routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public String getRuleCode() {
        return ruleCode;
    }

    public void setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
    }

    public String getTxId() {
        return txId;
    }

    public void setTxId(String txId) {
        this.txId = txId;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
