package com.xforceplus.phoenix.split.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@ApiModel
public class OrderInfo {

    @ApiModelProperty(value = "含税金额", required = true)
    @NotNull(message = "含税金额不能为空")
    private BigDecimal amountWithTax;

    @ApiModelProperty(value = "不含税金额", required = true)
    @NotNull(message = "不含税金额不能为空")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty(value = "税额", required = true)
    @NotNull(message = "税额不能为空")
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "明细", required = true)
    @NotEmpty(message = "明细不能为空")
    @Valid
    private List<OrderItem> orderItems;

    @ApiModelProperty("透传扩展属性")
    @Length(max = 10240, message = "透传扩展属性长度不能超过200")
    private String extInfo;


    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public List<OrderItem> getOrderItems() {
        return orderItems;
    }

    public void setOrderItems(List<OrderItem> orderItems) {
        this.orderItems = orderItems;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    @Override
    public String toString() {
        return "OrderInfo{" +
                "amountWithTax=" + amountWithTax +
                ", amountWithoutTax=" + amountWithoutTax +
                ", taxAmount=" + taxAmount +
                ", orderItems=" + orderItems +
                ", extInfo='" + extInfo + '\'' +
                '}';
    }
}
