package com.xforceplus.phoenix.split.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;
import java.math.BigDecimal;

@ApiModel
public class OrderItem {


    @ApiModelProperty(value = "含税金额", required = true)
    @NotNull(message = "含税金额不能为空")
    private BigDecimal amountWithTax;

    @ApiModelProperty(value = "不含税金额", required = true)
    @NotNull(message = "不含税金额不能为空")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty(value = "税额", required = true)
    @NotNull(message = "税额不能为空")
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "税率", required = true)
    @NotNull(message = "税率不能为空")
    private BigDecimal taxRate;

    @ApiModelProperty("单价, 如果是null, 需转换成零")
    @NotNull(message = "单价不能为空")
    @PositiveOrZero(message = "单价不能为负数")
    private BigDecimal unitPrice;

    @ApiModelProperty("数量, 如果是null, 需转换成零")
    @NotNull(message = "数量不能为空")
    private BigDecimal quantity;


    @ApiModelProperty(value = "价外折扣含税", required = true)
    @NotNull(message = "价外折扣含税不能为空")
    private BigDecimal outterDiscountWithTax;

    @ApiModelProperty(value = "价外折扣不含税", required = true)
    @NotNull(message = "价外折扣不含税不能为空")
    private BigDecimal outterDiscountWithoutTax;

    @ApiModelProperty(value = "价外折扣税额", required = true)
    @NotNull(message = "价外折扣税额不能为空")
    private BigDecimal outterDiscountTax;

    @ApiModelProperty(value = "价内折扣含税", required = true)
    @NotNull(message = "价内折扣含税不能为空")
    private BigDecimal innerDiscountWithTax;

    @ApiModelProperty(value = "价内折扣不含税", required = true)
    @NotNull(message = "价内折扣不含税不能为空")
    private BigDecimal innerDiscountWithoutTax;

    @ApiModelProperty(value = "价内折扣含税", required = true)
    @NotNull(message = "价内折扣含税不能为空")
    private BigDecimal innerDiscountTax;

    @ApiModelProperty("透传扩展属性")
    @Length(max = 10240, message = "透传扩展属性长度不能超过500")
    private String extInfo;

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getOutterDiscountWithTax() {
        return outterDiscountWithTax;
    }

    public void setOutterDiscountWithTax(BigDecimal outterDiscountWithTax) {
        this.outterDiscountWithTax = outterDiscountWithTax;
    }

    public BigDecimal getOutterDiscountWithoutTax() {
        return outterDiscountWithoutTax;
    }

    public void setOutterDiscountWithoutTax(BigDecimal outterDiscountWithoutTax) {
        this.outterDiscountWithoutTax = outterDiscountWithoutTax;
    }

    public BigDecimal getOutterDiscountTax() {
        return outterDiscountTax;
    }

    public void setOutterDiscountTax(BigDecimal outterDiscountTax) {
        this.outterDiscountTax = outterDiscountTax;
    }

    public BigDecimal getInnerDiscountWithTax() {
        return innerDiscountWithTax;
    }

    public void setInnerDiscountWithTax(BigDecimal innerDiscountWithTax) {
        this.innerDiscountWithTax = innerDiscountWithTax;
    }

    public BigDecimal getInnerDiscountWithoutTax() {
        return innerDiscountWithoutTax;
    }

    public void setInnerDiscountWithoutTax(BigDecimal innerDiscountWithoutTax) {
        this.innerDiscountWithoutTax = innerDiscountWithoutTax;
    }

    public BigDecimal getInnerDiscountTax() {
        return innerDiscountTax;
    }

    public void setInnerDiscountTax(BigDecimal innerDiscountTax) {
        this.innerDiscountTax = innerDiscountTax;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }


    @Override
    public String toString() {
        return "OrderItem{" +
                "amountWithTax=" + amountWithTax +
                ", amountWithoutTax=" + amountWithoutTax +
                ", taxAmount=" + taxAmount +
                ", taxRate=" + taxRate +
                ", unitPrice=" + unitPrice +
                ", quantity=" + quantity +
                ", outterDiscountWithTax=" + outterDiscountWithTax +
                ", outterDiscountWithoutTax=" + outterDiscountWithoutTax +
                ", outterDiscountTax=" + outterDiscountTax +
                ", innerDiscountWithTax=" + innerDiscountWithTax +
                ", innerDiscountWithoutTax=" + innerDiscountWithoutTax +
                ", innerDiscountTax=" + innerDiscountTax +
                ", extInfo='" + extInfo + '\'' +
                '}';
    }
}
