package com.xforceplus.phoenix.split.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@ApiModel
public class RemarkFieldMetadata {
    @ApiModelProperty(value = "字段名称")
    @NotBlank(message = "字段名不能为空")
    private String fieldName;

    @ApiModelProperty(value = "字段含义")
    private String fieldDisplayName;


    @ApiModelProperty(value = "字段分组索引 0-单据主信息 1-单据明细", allowableValues = "0, 1")
    @NotNull(message = "字段分组索引不能为空")
    private FieldOfObj fieldGroupIndex;



    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldDisplayName() {
        return fieldDisplayName;
    }

    public void setFieldDisplayName(String fieldDisplayName) {
        this.fieldDisplayName = fieldDisplayName;
    }

    public FieldOfObj getFieldGroupIndex() {
        return fieldGroupIndex;
    }

    public void setFieldGroupIndex(FieldOfObj fieldGroupIndex) {
        this.fieldGroupIndex = fieldGroupIndex;
    }

    @Override
    public String toString() {
        return "RemarkFieldMetadata{" +
                "fieldName='" + fieldName + '\'' +
                ", fieldDisplayName='" + fieldDisplayName + '\'' +
                ", fieldGroupIndex=" + fieldGroupIndex +
                '}';
    }
}
