package com.xforceplus.phoenix.split.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel
public class SplitOrderParam {

    @ApiModelProperty("拆分规则")
    @NotNull(message = "规则不能为空")
    @Valid
    private SplitOrderRule splitOrderRule;

    @ApiModelProperty("订单信息")
    @NotNull(message = "订单信息不能为空")
    @Valid
    private OrderInfo orderInfo;

    @ApiModelProperty("是否为负数订单，默认false")
    private boolean negativeOrder;

    public SplitOrderRule getSplitOrderRule() {
        return splitOrderRule;
    }

    public void setSplitOrderRule(SplitOrderRule splitOrderRule) {
        this.splitOrderRule = splitOrderRule;
    }

    public OrderInfo getOrderInfo() {
        return orderInfo;
    }

    public void setOrderInfo(OrderInfo orderInfo) {
        this.orderInfo = orderInfo;
    }

    public boolean isNegativeOrder() {
        return negativeOrder;
    }

    public void setNegativeOrder(boolean negativeOrder) {
        this.negativeOrder = negativeOrder;
    }

    @Override
    public String toString() {
        return "SplitOrderParam{" +
                "splitOrderRule=" + splitOrderRule +
                ", orderInfo=" + orderInfo +
                ", negativeOrder=" + negativeOrder +
                '}';
    }
}
