package com.xforceplus.phoenix.split.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import java.math.BigDecimal;

@ApiModel
public class SplitOrderRule {

    @ApiModelProperty("拆分金额")
    @Positive(message = "拆分金额必须大于零")
    @Digits(integer = 9,fraction = 2, message = "小数位必须在两位以内")
    private BigDecimal splitAmount;


    @ApiModelProperty(value = "金额拆分规则, 1=按数量拆单价,2=按单价拆数量", required = true)
    @NotBlank(message = "金额拆分规则不能为空")
    @Pattern(regexp = "[1|2]", message = "不合法的金额拆分规则, 合法值为[1,2]")
    private String amountSplitRule;

    @ApiModelProperty("单价小数位")
    private int unitPriceScale;

    @ApiModelProperty("数量小数位")
    private int quantityScale;


    public BigDecimal getSplitAmount() {
        return splitAmount;
    }

    public void setSplitAmount(BigDecimal splitAmount) {
        this.splitAmount = splitAmount;
    }

    public String getAmountSplitRule() {
        return amountSplitRule;
    }

    public void setAmountSplitRule(String amountSplitRule) {
        this.amountSplitRule = amountSplitRule;
    }

    public int getUnitPriceScale() {
        return unitPriceScale;
    }

    public void setUnitPriceScale(int unitPriceScale) {
        this.unitPriceScale = unitPriceScale;
    }

    public int getQuantityScale() {
        return quantityScale;
    }

    public void setQuantityScale(int quantityScale) {
        this.quantityScale = quantityScale;
    }

    @Override
    public String toString() {
        return "SplitOrderRule{" +
                "splitAmount=" + splitAmount +
                ", amountSplitRule='" + amountSplitRule + '\'' +
                ", unitPriceScale=" + unitPriceScale +
                ", quantityScale=" + quantityScale +
                '}';
    }
}
